/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Chainable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;

    private Chainable(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Nonnull
    public static <T> Chainable<T> chain(@Nonnull Iterable<T> iterable) {
        return new Chainable<T>((Iterable)Preconditions.checkNotNull(iterable, (Object)"iterable"));
    }

    @Nonnull
    public static <T> Chainable<T> chain(@Nonnull T[] elements) {
        return new Chainable<Object>(Arrays.asList((Object[])Preconditions.checkNotNull(elements, (Object)"elements")));
    }

    @Nonnull
    public Chainable<T> filter(@Nonnull Predicate<? super T> predicate) {
        return Chainable.chain(Iterables.filter(this.iterable, predicate));
    }

    @Nullable
    public T getFirst() {
        return this.iterable.iterator().next();
    }

    @Nullable
    public T getFirst(@Nullable T defaultValue) {
        return (T)Iterables.getFirst(this.iterable, defaultValue);
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.iterable);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    @Nonnull
    public Chainable<T> limit(int size) {
        return Chainable.chain(Iterables.limit(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<List<T>> partition(int size) {
        return Chainable.chain(Iterables.partition(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<T> skip(int size) {
        return Chainable.chain(Iterables.skip(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<T> sort(@Nonnull Comparator<? super T> comparator) {
        return this.sort(Ordering.from(comparator));
    }

    @Nonnull
    public Chainable<T> sort(@Nonnull Ordering<? super T> ordering) {
        return Chainable.chain(((Ordering)Preconditions.checkNotNull(ordering, (Object)"ordering")).immutableSortedCopy(this.iterable));
    }

    @Nonnull
    public Set<T> toSet() {
        return ImmutableSet.copyOf(this.iterable);
    }

    @Nonnull
    public List<T> toList() {
        return ImmutableList.copyOf(this.iterable);
    }

    @Nonnull
    public <R> Chainable<R> transform(@Nonnull Function<? super T, ? extends R> function) {
        return Chainable.chain(Iterables.transform(this.iterable, function));
    }

    @Nonnull
    public <R> Chainable<R> flatMap(@Nonnull Function<? super T, ? extends Iterable<? extends R>> function) {
        return Chainable.chain(Iterables.concat((Iterable)Iterables.transform(this.iterable, function)));
    }
}

