/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.user.Permission;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompositePermissionGraph
implements PermissionGraph {
    private static final PermissionGraph EMPTY = new PermissionGraph(){

        public boolean isGranted(Permission permission, @Nullable Object resource) {
            return false;
        }
    };
    private final PermissionGraph graph1;
    private final PermissionGraph graph2;

    public CompositePermissionGraph(@Nonnull PermissionGraph graph1, @Nonnull PermissionGraph graph2) {
        this.graph1 = (PermissionGraph)Preconditions.checkNotNull((Object)graph1, (Object)"graph1");
        this.graph2 = (PermissionGraph)Preconditions.checkNotNull((Object)graph2, (Object)"graph2");
    }

    @Nonnull
    public static PermissionGraph maybeCompose(@Nullable PermissionGraph graph1, @Nullable PermissionGraph graph2) {
        if (graph1 == null && graph2 == null) {
            return EMPTY;
        }
        if (graph1 == null) {
            return graph2;
        }
        if (graph2 == null) {
            return graph1;
        }
        return new CompositePermissionGraph(graph1, graph2);
    }

    public boolean isGranted(@Nonnull Permission permission, @Nullable Object resource) {
        return this.graph1.isGranted(permission, resource) || this.graph2.isGranted(permission, resource);
    }

    public String toString() {
        return "{CompositePermissionGraph graph1:" + this.graph1 + ", graph2:" + this.graph2 + "}";
    }
}

