/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.BeforePluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.compare.CompareRequest;
import com.atlassian.stash.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.stash.exception.UnsupportedScmTypeException;
import com.atlassian.stash.hook.ScmHookHandlerFactory;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.hook.PluginScmHookHandlerFactory;
import com.atlassian.stash.internal.maintenance.latch.ClusterableLatch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.latch.LatchState;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.PluginScmCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmCompareCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmPullRequestCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmRefCommandFactory;
import com.atlassian.stash.internal.scm.ScmLatch;
import com.atlassian.stash.internal.scm.SimpleAvailableScm;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AvailableScm;
import com.atlassian.stash.scm.DeleteCommandParameters;
import com.atlassian.stash.scm.FeatureUnsupportedScmException;
import com.atlassian.stash.scm.PluginCommandBuilderFactory;
import com.atlassian.stash.scm.PluginCommandFactory;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.Scm3;
import com.atlassian.stash.scm.ScmAdapter3;
import com.atlassian.stash.scm.ScmCommandBuilder;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmFeature;
import com.atlassian.stash.scm.ScmModuleDescriptor;
import com.atlassian.stash.scm.ScmProtocol;
import com.atlassian.stash.scm.ScmProtocolModuleDescriptor;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.ScmStatus;
import com.atlassian.stash.scm.UnavailableScmException;
import com.atlassian.stash.scm.UnsupportedScmException;
import com.atlassian.stash.scm.compare.PluginCompareCommandFactory;
import com.atlassian.stash.scm.compare.ScmCompareCommandFactory;
import com.atlassian.stash.scm.event.ScmStatusChangedEvent;
import com.atlassian.stash.scm.hook.PluginHookHandlerFactory;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.stash.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.stash.scm.pull.ScmPullRequestCommandFactory;
import com.atlassian.stash.scm.ref.PluginRefCommandFactory;
import com.atlassian.stash.scm.ref.ScmRefCommandFactory;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Drainable;
import com.atlassian.stash.util.ForcedDrainable;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.IExecutorService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ScmService.class)
@Service(value="scmService")
public class PluginScmService
implements InternalScmService,
BeanNameAware {
    private static final Predicate<Scm> IS_AVAILABLE = new Predicate<Scm>(){

        public boolean apply(Scm scm) {
            return scm.getStatus().isAvailable();
        }
    };
    private static final String SCM_GIT = "git";
    private static final String STARS = StringUtils.repeat((String)"*", (int)75);
    private static final Logger log = LoggerFactory.getLogger(PluginScmService.class);
    private final LoadingCache<String, Scm3> cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, Scm3>(){

        public Scm3 apply(String scmId) {
            log.debug("Cache miss for SCM {}; searching plugins", (Object)scmId);
            for (Scm scm : PluginScmService.this.getEnabledScms()) {
                if (!StringUtils.equals((String)scmId, (String)scm.getId())) continue;
                ScmStatus status = scm.getStatus();
                if (status.isAvailable()) {
                    return ScmAdapter3.wrap((Scm)scm);
                }
                throw PluginScmService.this.unavailableScm(scmId, status.getMessage());
            }
            throw PluginScmService.this.unsupportedScm(scmId);
        }
    }));
    private final Cluster cluster;
    private final DatabaseManager databaseManager;
    private final EventPublisher eventPublisher;
    private final IExecutorService executorService;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private String beanName;
    private volatile DefaultScmLatch latch;

    @Autowired
    public PluginScmService(Cluster cluster, DatabaseManager databaseManager, EventPublisher eventPublisher, IExecutorService executorService, I18nService i18nService, PluginAccessor pluginAccessor) {
        this.cluster = cluster;
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public ScmLatch acquireLatch(@Nonnull LatchMode latchMode) {
        return this.acquireLatch(latchMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ScmLatch acquireLatch(@Nonnull LatchMode mode, String latchId) {
        String string = SCM_GIT;
        synchronized (SCM_GIT) {
            Preconditions.checkState((!this.isLatched() ? 1 : 0) != 0, (Object)"SCMs have already been latched");
            Preconditions.checkState((boolean)this.databaseManager.isLatched(), (Object)"SCMs can only be latched after the database is latched");
            DefaultScmLatch newLatch = new DefaultScmLatch(mode);
            newLatch.acquire(latchId);
            this.latch = newLatch;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return newLatch;
        }
    }

    @Nonnull
    public ScmCommandBuilder<?> createBuilder(@Nonnull Repository repository) {
        Scm3 scm = this.findByRepository(repository);
        PluginCommandBuilderFactory builderFactory = scm.getCommandBuilderFactory();
        if (builderFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.COMMAND_BUILDERS);
        }
        return builderFactory.builder(repository);
    }

    public void delete(@Nonnull Repository repository, @Nonnull DeleteCommandParameters parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters");
        this.findByRepository(repository).getCommandFactory().delete(repository, parameters).synchronous().call();
    }

    @Nonnull
    public Scm3 findById(@Nonnull String scmId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((String)Preconditions.checkNotNull((Object)scmId, (Object)"scmId"))), (Object)"An scmId is required to locate an SCM");
        try {
            return (Scm3)this.cache.getUnchecked((Object)scmId);
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Nonnull
    public Scm3 findByRepository(@Nonnull Repository repository) {
        return this.findById(((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getScmId());
    }

    @Nonnull
    public Set<AvailableScm> getAvailable() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet ids = Sets.newHashSet();
        for (Scm scm : this.getEnabledScms()) {
            if (!scm.getStatus().isAvailable()) continue;
            String id = scm.getId();
            if (ids.add(id)) {
                builder.add((Object)new SimpleAvailableScm.Builder(id).name(scm.getName()).build());
                continue;
            }
            log.warn("Multiple SCMs have registered with ID {}; {} will be ignored", (Object)id, (Object)scm.getName());
        }
        return builder.build();
    }

    @Nonnull
    public ScmCommandFactory getCommandFactory(@Nonnull Repository repository) {
        return new PluginScmCommandFactory(repository, (PluginCommandFactory)this.findByRepository(repository).getCommandFactory());
    }

    @Nonnull
    public ScmCompareCommandFactory getCompareCommandFactory(@Nonnull CompareRequest compareRequest) {
        return new PluginScmCompareCommandFactory(compareRequest, this.compareCommandFactory(compareRequest));
    }

    @Nullable
    public ScmLatch getCurrentLatch() {
        return this.latch;
    }

    @Nonnull
    public ScmHookHandlerFactory getHookHandlerFactory(@Nonnull Repository repository) {
        return new PluginScmHookHandlerFactory(repository, this.hookHandlerFactory(repository));
    }

    @Nonnull
    public Set<ScmProtocol> getProtocols(@Nonnull Repository repository) {
        Scm3 scm = this.findById(repository.getScmId());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ScmProtocol scmProtocol : this.getEnabledProtocols()) {
            if (!scmProtocol.supports((Scm)scm)) continue;
            builder.add((Object)scmProtocol);
        }
        return builder.build();
    }

    @Nonnull
    public ScmPullRequestCommandFactory getPullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return new PluginScmPullRequestCommandFactory(pullRequest, this.pullRequestCommandFactory(pullRequest));
    }

    @Nonnull
    public ScmRefCommandFactory getRefCommandFactory(@Nonnull Repository repository) {
        return new PluginScmRefCommandFactory(repository, this.refCommandFactory(repository));
    }

    @Nonnull
    public String getScmName(@Nonnull Repository repository) {
        return this.findByRepository(repository).getName();
    }

    @Nonnull
    public LatchState getState() {
        ScmLatch scmLatch = this.getCurrentLatch();
        if (scmLatch == null) {
            return LatchState.AVAILABLE;
        }
        if (scmLatch.drain(0L, TimeUnit.NANOSECONDS)) {
            return LatchState.DRAINED;
        }
        return LatchState.LATCHED;
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.findByRepository(repository).isEmpty(repository);
    }

    public boolean isLatched() {
        return this.latch != null;
    }

    @NotProfiled
    public boolean isSupported(@Nonnull Repository repository, @Nonnull ScmFeature feature) {
        return this.findByRepository(repository).getFeatures().contains(Preconditions.checkNotNull((Object)feature, (Object)"feature"));
    }

    @EventListener
    public void onBeforePluginDisabled(BeforePluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        log.debug("Plugin {} is being disabled; checking for SCMs", (Object)plugin.getKey());
        this.invalidateCacheForDisabledScms(plugin);
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        DefaultScmLatch current = this.latch;
        if (current != null) {
            current.onNodeJoined(event.getAddedNode());
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.checkGitStatus();
    }

    @EventListener
    public void onStatusChanged(ScmStatusChangedEvent event) {
        Scm scm = event.getScm();
        log.debug("Invaliding cached Scm for SCM {} after status change", (Object)scm.getId());
        this.cache.invalidate((Object)scm.getId());
        if (SCM_GIT.equals(scm.getId())) {
            this.checkGitStatus();
        }
    }

    public void rescope(@Nonnull RepositoryRescopeCommandParameters parameters) {
        this.pullRequestCommandFactory(((RepositoryRescopeCommandParameters)Preconditions.checkNotNull((Object)parameters, (Object)"parameters")).getRepository()).rescope(parameters).call();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    private void checkGitStatus() {
        try {
            Scm3 scm = this.findById(SCM_GIT);
            KeyedMessage statusMessage = scm.getStatus().getMessage();
            if (statusMessage != null) {
                log.info(statusMessage.getRootMessage());
            }
        }
        catch (UnavailableScmException e) {
            String localisedMessage = e.getLocalizedMessage();
            log.error(STARS);
            log.error(localisedMessage);
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), localisedMessage, EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
        catch (UnsupportedScmTypeException e) {
            log.error(STARS);
            log.error(e.getLocalizedMessage());
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getMessage("stash.plugin.failed", new Object[]{"Git SCM Plugin"}), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
    }

    @Nonnull
    private PluginCompareCommandFactory compareCommandFactory(@Nonnull CompareRequest compareRequest) {
        Repository repository = ((CompareRequest)Preconditions.checkNotNull((Object)compareRequest, (Object)"compareRequest")).getToRef().getRepository();
        Scm3 scm = this.findByRepository(repository);
        PluginCompareCommandFactory commandFactory = scm.getCompareCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.COMPARE);
        }
        return commandFactory;
    }

    private <T, D extends ModuleDescriptor<T>> Iterable<D> getEnabledModuleDescriptors(Class<D> descriptorClass) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass);
    }

    private Iterable<ScmProtocol> getEnabledProtocols() {
        return ModuleDescriptorUtils.toModules(this.getEnabledModuleDescriptors(ScmProtocolModuleDescriptor.class));
    }

    private Iterable<Scm> getEnabledScms() {
        return ModuleDescriptorUtils.toSortedModules(this.getEnabledModuleDescriptors(ScmModuleDescriptor.class));
    }

    private FeatureUnsupportedScmException featureUnsupported(String scmId, ScmFeature feature) {
        throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("stash.scm.feature.unsupported", new Object[]{scmId, feature}), scmId, feature);
    }

    @Nonnull
    private PluginHookHandlerFactory hookHandlerFactory(@Nonnull Repository repository) {
        Scm3 scm = this.findByRepository(repository);
        PluginHookHandlerFactory handlerFactory = scm.getHookHandlerFactory();
        if (handlerFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.HOOKS);
        }
        return handlerFactory;
    }

    private void invalidateCacheForDisabledScms(Plugin plugin) {
        List descriptors = plugin.getModuleDescriptorsByModuleClass(Scm.class);
        if (CollectionUtils.isEmpty((Collection)descriptors)) {
            log.debug("Plugin {} did not provide any SCMs", (Object)plugin.getKey());
        } else {
            log.debug("Plugin {} provided {} SCM(s); removing from cache if present", (Object)plugin.getKey(), (Object)descriptors.size());
            for (ModuleDescriptor descriptor : descriptors) {
                Scm scm = (Scm)descriptor.getModule();
                log.debug("Invalidating cached Scm for SCM {} after disabling", (Object)scm.getId());
                this.cache.invalidate((Object)scm.getId());
            }
        }
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return this.pullRequestCommandFactory(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository());
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull Repository repository) {
        Scm3 scm = this.findByRepository(repository);
        PluginPullRequestCommandFactory commandFactory = scm.getPullRequestCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.PULL_REQUESTS);
        }
        return commandFactory;
    }

    @Nonnull
    private PluginRefCommandFactory refCommandFactory(@Nonnull Repository repository) {
        Scm3 scm = this.findByRepository(repository);
        PluginRefCommandFactory commandFactory = scm.getRefCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.REFS);
        }
        return commandFactory;
    }

    private UnavailableScmException unavailableScm(String scmId, KeyedMessage statusMessage) {
        throw new UnavailableScmException(statusMessage, scmId);
    }

    private UnsupportedScmException unsupportedScm(String scmId) {
        throw new UnsupportedScmException(this.i18nService.createKeyedMessage("stash.scm.unsupported", new Object[]{scmId}), scmId);
    }

    private class DefaultScmLatch
    extends ClusterableLatch
    implements ScmLatch {
        public DefaultScmLatch(LatchMode mode) {
            super(mode, PluginScmService.this.cluster, PluginScmService.this.executorService, PluginScmService.this.beanName);
        }

        @Override
        protected void acquireLocally() {
        }

        @Override
        protected boolean drainLocally(long timeout, @Nonnull TimeUnit unit, boolean force) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
            this.ensureInitiator();
            long timeoutNs = unit.toNanos(timeout);
            long remainingNs = Math.max(0L, timeoutNs);
            log.debug("Draining SCMs with timeout of {}ms", (Object)unit.toMillis(timeout));
            for (Scm scm : this.getDrainableScms()) {
                log.debug("Draining SCM {}", (Object)scm);
                Timer ignored = TimerUtils.start((String)("Draining SCM " + scm));
                Throwable throwable = null;
                try {
                    boolean drained;
                    long startNs = System.nanoTime();
                    boolean bl = drained = force && scm instanceof ForcedDrainable ? ((ForcedDrainable)scm).forceDrain(remainingNs, TimeUnit.NANOSECONDS) : ((Drainable)scm).drain(remainingNs, TimeUnit.NANOSECONDS);
                    if (!drained) {
                        log.warn("Failed to drain SCM {} in remaining allocated time ({}ms) of total ({}ms)", new Object[]{scm, TimeUnit.NANOSECONDS.toMillis(remainingNs), unit.toMillis(timeout)});
                        boolean bl2 = false;
                        return bl2;
                    }
                    remainingNs = Math.max(0L, remainingNs - (System.nanoTime() - startNs));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void unlatchLocally() {
            this.ensureInitiator();
            String string = PluginScmService.SCM_GIT;
            synchronized (PluginScmService.SCM_GIT) {
                PluginScmService.this.latch = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void ensureInitiator() {
            Preconditions.checkState((PluginScmService.this.latch == this ? 1 : 0) != 0, (Object)"This latch is no longer active");
        }

        private Iterable<Scm> getDrainableScms() {
            return Chainable.chain((Iterable)PluginScmService.this.getEnabledScms()).filter(Predicates.instanceOf(Drainable.class)).filter(IS_AVAILABLE);
        }
    }
}

