/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.stash.commit.CommitCallback;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactory2;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactoryAdapter;
import com.atlassian.stash.scm.pull.PullRequestChangeCommandParameters;
import com.atlassian.stash.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.stash.scm.pull.ScmPullRequestCommandFactory;
import javax.annotation.Nonnull;

public class PluginScmPullRequestCommandFactory
implements ScmPullRequestCommandFactory {
    private final PluginPullRequestCommandFactory2 commandFactory;
    private final PullRequest pullRequest;

    public PluginScmPullRequestCommandFactory(PullRequest pullRequest, PluginPullRequestCommandFactory commandFactory) {
        this.pullRequest = pullRequest;
        this.commandFactory = PluginPullRequestCommandFactoryAdapter.wrap((PluginPullRequestCommandFactory)commandFactory);
    }

    @Nonnull
    public Command<Boolean> canMerge() {
        return this.commandFactory.canMerge(this.pullRequest);
    }

    @Nonnull
    public Command<Void> changes(@Nonnull PullRequestChangeCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull ChangesetCallback callback) {
        return this.commandFactory.commits(this.pullRequest, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.pullRequest, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull PullRequestDiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<PullRequestEffectiveDiff> effectiveDiff() {
        return this.commandFactory.effectiveDiff(this.pullRequest);
    }

    @Nonnull
    public Command<Branch> merge(@Nonnull PullRequestMergeCommandParameters parameters) {
        return this.commandFactory.merge(this.pullRequest, parameters);
    }
}

