/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.sal.user.DelegatingUserSettings;
import com.atlassian.stash.internal.sal.user.MapUserSettingsBuilder;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.atlassian.stash.internal.user.UserSettingsDao;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserSettingsService.class)
@Service(value="userSettingsService")
public class DefaultUserSettingsService
extends AbstractService
implements InternalUserSettingsService {
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final SettingsHelper settingsHelper;
    private final InternalUserService userService;
    private final UserSettingsDao userSettingsDao;

    @Autowired
    public DefaultUserSettingsService(@Nonnull InternalUserService userService, @Nonnull UserSettingsDao userSettingsDao, @Nonnull SettingsHelper settingsHelper, @Nonnull StashAuthenticationContext authenticationContext, @Nonnull PermissionService permissionService, @Nonnull I18nService i18nService) {
        this.userService = userService;
        this.userSettingsDao = userSettingsDao;
        this.settingsHelper = settingsHelper;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.i18nService = i18nService;
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserSettings getUserSettings(@Nonnull String username) {
        if (username == null) {
            return null;
        }
        return this.getUserSettings(this.checkUser(this.userService.getUserByName(username)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserSettings getUserSettings(UserKey userKey) {
        if (userKey == null) {
            return null;
        }
        return this.getUserSettings(this.checkUser(this.userService.getUserByKey(userKey)));
    }

    @Unsecured(value="Internal service method")
    public UserSettings getUserSettings(StashUser user) {
        if (user == null) {
            return null;
        }
        InternalUserSettings internalUserSettings = (InternalUserSettings)this.userSettingsDao.getById((Object)user.getId());
        MapUserSettingsBuilder builder = new MapUserSettingsBuilder();
        if (internalUserSettings != null) {
            builder.putAll(this.settingsHelper.deserialize(internalUserSettings.getSettings().getData()));
        }
        return builder.build();
    }

    @Secured(value="Secured using a code permission check")
    @Transactional
    public void updateUserSettings(UserKey userKey, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Preconditions.checkNotNull((Object)userKey, (Object)"userKey");
        Preconditions.checkNotNull(updateFunction, (Object)"updateFunction");
        this.updateUserSettings(this.checkUserAndPermissions(this.userService.getUserByKey(userKey)), updateFunction);
    }

    @Secured(value="Secured using a code permission check")
    @Transactional
    public void updateUserSettings(String username, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkNotNull(updateFunction, (Object)"updateFunction");
        this.updateUserSettings(this.checkUserAndPermissions(this.userService.getUserByName(username)), updateFunction);
    }

    @Transactional
    @Unsecured(value="Internal service method")
    public void updateUserSettings(@Nonnull StashUser user, @Nonnull Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        InternalUserSettings internalUserSettings = (InternalUserSettings)this.userSettingsDao.getById((Object)user.getId());
        MapUserSettingsBuilder userSettingsBuilder = new MapUserSettingsBuilder();
        if (internalUserSettings != null) {
            Settings settings = this.settingsHelper.deserialize(internalUserSettings.getSettings().getData());
            userSettingsBuilder.putAll(settings);
        }
        DelegatingUserSettings userSettings = (DelegatingUserSettings)updateFunction.apply((Object)userSettingsBuilder);
        InternalSharedLob settingsLob = new InternalSharedLob.Builder().data(this.settingsHelper.serialize(userSettings.getSettings())).build();
        InternalUserSettings.Builder internalUserSettingsBuilder = internalUserSettings != null ? new InternalUserSettings.Builder(internalUserSettings) : new InternalUserSettings.Builder().user(InternalConverter.convertToInternalUser((StashUser)user));
        this.userSettingsDao.update((Object)internalUserSettingsBuilder.settings(settingsLob).build());
    }

    private StashUser checkUser(StashUser user) {
        if (user == null) {
            throw new IllegalArgumentException(this.i18nService.createKeyedMessage("stash.service.user.settings.nosuchuser", new Object[0]).getLocalisedMessage());
        }
        return user;
    }

    private StashUser checkUserAndPermissions(StashUser user) {
        boolean isAuthorized;
        this.checkUser(user);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = isAuthorized = StashUserEquality.equals((StashUser)user, (Object)currentUser) || this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) || this.permissionService.hasGlobalPermission(currentUser, Permission.ADMIN) && !this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN);
        if (!isAuthorized) {
            KeyedMessage keyedMessage = this.i18nService.createKeyedMessage("stash.service.user.settings.unauthorized", new Object[]{user.getDisplayName()});
            throw new AuthorisationException(keyedMessage);
        }
        return user;
    }
}

