/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="stashLocaleResolver")
@AvailableToPlugins(value=LocaleResolver.class)
public class StashLocaleResolver
implements LocaleResolver {
    private final InternalLanguageService languageService;
    private final InternalLocaleManager localeManager;
    private final InternalLocaleService localeService;
    private final InternalUserService userService;

    @Autowired
    public StashLocaleResolver(InternalLanguageService languageService, InternalLocaleManager localeManager, InternalLocaleService localeService, InternalUserService userService) {
        this.languageService = languageService;
        this.localeManager = localeManager;
        this.localeService = localeService;
        this.userService = userService;
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.getLocale();
    }

    public Locale getLocale() {
        return this.processLocale(this.localeService.getLocale());
    }

    public Locale getLocale(@Nullable UserKey userKey) {
        StashUser user = this.userService.getUserByKey(userKey);
        return this.processLocale(user != null ? this.localeManager.getLocale(user) : null);
    }

    public Set<Locale> getSupportedLocales() {
        return Chainable.chain((Iterable)this.languageService.getLanguages()).transform((Function)new Function<Language, Locale>(){

            public Locale apply(Language input) {
                return input.getLocale();
            }
        }).toSet();
    }

    private Locale processLocale(Locale locale) {
        return (Locale)Objects.firstNonNull((Object)locale, (Object)Locale.getDefault());
    }
}

