/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.plugin.RefMetadataProviderModuleDescriptor;
import com.atlassian.stash.internal.repository.RefMetadataMapProvider;
import com.atlassian.stash.repository.MetadataMap;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefMetadataContext;
import com.atlassian.stash.repository.SimpleMetadataMap;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PluginRefMetadataMapProvider
implements RefMetadataMapProvider {
    private static final Logger log = LoggerFactory.getLogger(PluginRefMetadataMapProvider.class);
    private final ExecutorService executorService;
    private final PluginAccessor pluginAccessor;
    private int timeout;

    @Autowired
    public PluginRefMetadataMapProvider(ExecutorService executorService, PluginAccessor pluginAccessor) {
        this.executorService = executorService;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Map<Ref, MetadataMap> getMetadata(@Nonnull RefMetadataContext context) {
        HashMap builders = Maps.newHashMap();
        for (ModuleMetadata promisedMetadata : this.getModuleMetadata(context)) {
            try {
                this.collectMetadata(builders, promisedMetadata.getDescriptor(), promisedMetadata.getFuture().get());
            }
            catch (InterruptedException ignored) {
            }
            catch (CancellationException ignored) {
                log.info("Timed out when retrieving ref metadata for {}", (Object)promisedMetadata.getDescriptor().getCompleteKey());
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf((Throwable)e.getCause(), Error.class);
                log.warn("Failed to retrieve ref metadata for {}", (Object)promisedMetadata.getDescriptor().getCompleteKey(), (Object)e.getCause());
            }
        }
        return this.buildMetadataMaps(builders);
    }

    @Value(value="${ref.metadata.timeout}")
    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private Map<Ref, MetadataMap> buildMetadataMaps(Map<Ref, ImmutableMap.Builder<String, Object>> builders) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(builders, (Function)new Function<ImmutableMap.Builder<String, Object>, MetadataMap>(){

            public MetadataMap apply(ImmutableMap.Builder<String, Object> builder) {
                return new SimpleMetadataMap((Map)builder.build());
            }
        }));
    }

    private void collectMetadata(Map<Ref, ImmutableMap.Builder<String, Object>> builders, RefMetadataProviderModuleDescriptor descriptor, Map<Ref, ?> metadata) {
        for (Map.Entry<Ref, ?> refMetadata : metadata.entrySet()) {
            ImmutableMap.Builder builder = builders.get(refMetadata.getKey());
            if (builder == null) {
                builder = ImmutableMap.builder();
                builders.put(refMetadata.getKey(), (ImmutableMap.Builder<String, Object>)builder);
            }
            builder.put((Object)descriptor.getCompleteKey(), refMetadata.getValue());
        }
    }

    private Callable<Map<Ref, ?>> createGetMetadataCallable(final RefMetadataContext context, final RefMetadataProviderModuleDescriptor descriptor) {
        return new Callable<Map<Ref, ?>>(){

            @Override
            public Map<Ref, ?> call() throws Exception {
                try (Timer timer = TimerUtils.start((String)String.format("Ref metadata [%s]", descriptor.getCompleteKey()));){
                    Map metadata = descriptor.getModule().getMetadata(context);
                    Map map = metadata != null ? Maps.filterValues((Map)Maps.filterKeys((Map)metadata, (Predicate)Predicates.notNull()), (Predicate)Predicates.notNull()) : Collections.emptyMap();
                    return map;
                }
            }
        };
    }

    private Iterable<ModuleMetadata> getModuleMetadata(final RefMetadataContext context) {
        Iterator futures;
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RefMetadataProviderModuleDescriptor.class);
        try {
            futures = this.executorService.invokeAll(ImmutableList.copyOf((Collection)Lists.transform((List)descriptors, (Function)new Function<RefMetadataProviderModuleDescriptor, Callable<Map<Ref, ?>>>(){

                public Callable<Map<Ref, ?>> apply(RefMetadataProviderModuleDescriptor descriptor) {
                    return PluginRefMetadataMapProvider.this.createGetMetadataCallable(context, descriptor);
                }
            })), this.timeout, TimeUnit.SECONDS).iterator();
        }
        catch (InterruptedException ignored) {
            return Collections.emptySet();
        }
        ArrayList moduleMetadata = Lists.newArrayListWithCapacity((int)descriptors.size());
        for (RefMetadataProviderModuleDescriptor descriptor : descriptors) {
            moduleMetadata.add(new ModuleMetadata(descriptor, futures.next()));
        }
        return moduleMetadata;
    }

    static class ModuleMetadata {
        private final RefMetadataProviderModuleDescriptor descriptor;
        private final Future<Map<Ref, ?>> future;

        ModuleMetadata(RefMetadataProviderModuleDescriptor descriptor, Future<Map<Ref, ?>> future) {
            this.descriptor = descriptor;
            this.future = future;
        }

        RefMetadataProviderModuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        Future<Map<Ref, ?>> getFuture() {
            return this.future;
        }
    }
}

