/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.concurrent.BucketProcessor;
import com.atlassian.stash.concurrent.BucketedExecutor;
import com.atlassian.stash.concurrent.BucketedExecutorSettings;
import com.atlassian.stash.concurrent.ConcurrencyPolicy;
import com.atlassian.stash.concurrent.ConcurrencyService;
import com.atlassian.stash.event.RepositoryPushEvent;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeTask;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.EscalatedSecurityContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PullRequestRescopeBucketProcessor
extends AbstractSmartLifecycle
implements BucketProcessor<PullRequestRescopeTask> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeBucketProcessor.class);
    private final RescopeRequestDao dao;
    private final long delayIncrementSeconds;
    private final BucketedExecutor<PullRequestRescopeTask> executor;
    private final int maxAttempts;
    private final RepositoryService repositoryService;
    private final InternalPullRequestRescopeService rescopeService;
    private final TransactionTemplate transactionTemplate;
    private final EscalatedSecurityContext withRepoRead;

    @Autowired
    public PullRequestRescopeBucketProcessor(ConcurrencyService concurrencyService, RescopeRequestDao dao, RepositoryService repositoryService, InternalPullRequestRescopeService rescopeService, SecurityService securityService, PlatformTransactionManager transactionManager, @Value(value="${pullrequest.rescope.max.attempts}") int maxAttempts, @Value(value="${pullrequest.rescope.retry.delay.increment}") long delayIncrement, @Value(value="${pullrequest.rescope.threads}") int maxThreads) {
        this.dao = dao;
        this.delayIncrementSeconds = delayIncrement;
        this.maxAttempts = maxAttempts;
        this.repositoryService = repositoryService;
        this.rescopeService = rescopeService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.executor = concurrencyService.getBucketedExecutor("pull-request-rescoping", new BucketedExecutorSettings.Builder(PullRequestRescopeTask.TO_BUCKET_ID, (BucketProcessor)this).maxAttempts(1).maxConcurrency(maxThreads, ConcurrencyPolicy.PER_NODE).build());
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, ((Object)((Object)this)).getClass().getSimpleName());
    }

    public int getPhase() {
        return 1600;
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        final Collection changes = event.getRefChanges();
        if (!(event instanceof RepositoryPushEvent) && CollectionUtils.isEmpty((Collection)changes)) {
            return;
        }
        final InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)event.getRepository());
        final InternalStashUser user = InternalConverter.convertToInternalUser((StashUser)event.getUser());
        if (user == null) {
            log.debug("Skipping rescopes for repository {}/{} because the triggering user could not be determined", (Object)repository.getProject().getKey(), (Object)repository.getSlug());
            return;
        }
        Iterable createdRequests = (Iterable)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<InternalRescopeRequest>>(){

            public Iterable<InternalRescopeRequest> doInTransaction(TransactionStatus status) {
                ArrayList<InternalRescopeRequest> requests = new ArrayList<InternalRescopeRequest>();
                for (RefChange change : changes) {
                    InternalRescopeRequest request = (InternalRescopeRequest)PullRequestRescopeBucketProcessor.this.dao.create((Object)new InternalRescopeRequest(repository, change.getRefId(), user));
                    requests.add(request);
                }
                return requests;
            }
        });
        for (InternalRescopeRequest request : createdRequests) {
            this.schedule(request);
            log.debug("{}: scheduled rescope request for branch {}", (Object)repository, (Object)request.getBranchId());
        }
    }

    public void process(@Nonnull String bucketId, final @Nonnull List<PullRequestRescopeTask> tasks) {
        final Set rescopeRequestIds = Chainable.chain(tasks).transform(PullRequestRescopeTask.TO_REQUEST_ID).toSet();
        final List requests = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<InternalRescopeRequest>>(){

            public List<InternalRescopeRequest> doInTransaction(TransactionStatus status) {
                return PullRequestRescopeBucketProcessor.this.dao.getByIds((Collection)rescopeRequestIds);
            }
        });
        if (rescopeRequestIds.size() != requests.size()) {
            Set<Long> missing = PullRequestRescopeBucketProcessor.findMissing(rescopeRequestIds, requests);
            Repository repository = this.getRepository(Integer.parseInt(bucketId));
            if (repository == null) {
                log.debug("Ignoring rescope requests {} as repository with id {} has been deleted", missing, (Object)bucketId);
            } else {
                log.info("{}: {} out of {} rescope requests have already been processed {}.", new Object[]{repository, missing.size(), tasks.size(), missing});
            }
        }
        if (requests.isEmpty()) {
            return;
        }
        final InternalRepository repository = ((InternalRescopeRequest)requests.get(0)).getRepository();
        final Map<String, InternalStashUser> branchesToUsers = PullRequestRescopeBucketProcessor.getBranchesToUsers(requests);
        final RepositoryRescopeResult result = this.rescopeService.rescope((Repository)repository, Collections.unmodifiableMap(branchesToUsers));
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                if (!result.isDone()) {
                    int attempt = PullRequestRescopeBucketProcessor.getMaxAttempt(tasks) + 1;
                    if (attempt <= PullRequestRescopeBucketProcessor.this.maxAttempts || result.hasSkippedAny()) {
                        Iterable rescheduleRequests = PullRequestRescopeBucketProcessor.this.createRequests(repository, branchesToUsers);
                        long delayMs = attempt <= PullRequestRescopeBucketProcessor.this.maxAttempts ? PullRequestRescopeBucketProcessor.this.getDelayMillis(attempt) : InternalPullRequest.LOCK_TIMEOUT_MILLIS;
                        log.debug("{}: Not all pull requests were rescoped. ({} failed, {} locked). Scheduling attempt {} in {}ms", new Object[]{repository, result.getErrorCount(), result.getSkippedCount(), attempt, delayMs});
                        for (InternalRescopeRequest request : rescheduleRequests) {
                            PullRequestRescopeBucketProcessor.this.schedule(request, attempt, delayMs);
                        }
                    } else {
                        log.info("{}: Failed to rescope one or more pull requests ({} attempts)", (Object)repository, (Object)attempt);
                    }
                }
                PullRequestRescopeBucketProcessor.this.dao.deleteAll(requests);
                return null;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("{}: processed rescope requests {}", (Object)repository, (Object)Chainable.chain((Iterable)requests).transform(InternalRescopeRequest.TO_ID).toList());
        }
    }

    public void start() {
        List requests = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<InternalRescopeRequest>>(){

            public List<InternalRescopeRequest> doInTransaction(TransactionStatus status) {
                return PullRequestRescopeBucketProcessor.this.dao.findAll();
            }
        });
        for (InternalRescopeRequest request : requests) {
            this.executor.submit((Serializable)new PullRequestRescopeTask(request.getId(), request.getRepository().getId(), 1));
        }
        if (!requests.isEmpty()) {
            List requestIds = Chainable.chain((Iterable)requests).transform(InternalRescopeRequest.TO_ID).toList();
            log.info("Rescheduled {} rescope requests on startup: {}", (Object)requestIds.size(), (Object)requestIds);
        }
        super.start();
    }

    public void stop() {
        this.executor.shutdown();
        super.stop();
    }

    private static int getMaxAttempt(List<PullRequestRescopeTask> tasks) {
        int max = 1;
        for (PullRequestRescopeTask task : tasks) {
            max = Math.max(task.getAttempt(), max);
        }
        return max;
    }

    private static Set<Long> findMissing(Set<Long> requestIds, Iterable<InternalRescopeRequest> requests) {
        return Sets.difference(requestIds, (Set)Chainable.chain(requests).transform(InternalRescopeRequest.TO_ID).toSet());
    }

    private static Map<String, InternalStashUser> getBranchesToUsers(List<InternalRescopeRequest> requests) {
        HashMap<String, InternalStashUser> branchesToUsers = new HashMap<String, InternalStashUser>();
        for (InternalRescopeRequest request : requests) {
            String key = Strings.emptyToNull((String)request.getBranchId());
            branchesToUsers.put(key, request.getUser());
        }
        return branchesToUsers;
    }

    private long getDelayMillis(int attempt) {
        return TimeUnit.SECONDS.toMillis(Math.max(0L, (long)(attempt - 1) * this.delayIncrementSeconds));
    }

    private Repository getRepository(final int repositoryId) {
        return (Repository)this.withRepoRead.call((Operation)new UncheckedOperation<Repository>(){

            public Repository perform() {
                return PullRequestRescopeBucketProcessor.this.repositoryService.getById(repositoryId);
            }
        });
    }

    private Iterable<InternalRescopeRequest> createRequests(InternalRepository repository, Map<String, InternalStashUser> branchesToUsers) {
        ArrayList<InternalRescopeRequest> requests = new ArrayList<InternalRescopeRequest>();
        for (Map.Entry<String, InternalStashUser> entry : branchesToUsers.entrySet()) {
            InternalRescopeRequest request = (InternalRescopeRequest)this.dao.create((Object)new InternalRescopeRequest(repository, entry.getKey(), entry.getValue()));
            requests.add(request);
        }
        return requests;
    }

    private void schedule(InternalRescopeRequest request) {
        this.schedule(request, 1, 0L);
    }

    private void schedule(InternalRescopeRequest request, int attempt, long delayMs) {
        PullRequestRescopeTask task = new PullRequestRescopeTask(request.getId(), request.getRepository().getId(), attempt);
        this.executor.schedule((Serializable)task, delayMs, TimeUnit.MILLISECONDS);
    }
}

