/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.stash.content.AbstractChangeCallback;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangeSummary;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.DriftResult;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ChangesCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class FileCommentDriftStrategy
implements CommentDriftStrategy,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(FileCommentDriftStrategy.class);
    private final ScmService scmService;
    @Value(value="${page.max.changes}")
    private int maxChanges;

    @Autowired
    public FileCommentDriftStrategy(ScmService scmService) {
        this.scmService = scmService;
    }

    @Override
    public void apply(@Nonnull DriftContext driftContext) {
        DriftResult driftResult = this.processPullRequestDiff(driftContext);
        driftResult.applyTo(driftContext);
    }

    @Override
    public String getName() {
        return "FileComment";
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void processChanges(ScmCommandFactory commandFactory, FileCommentDriftCallback callback, PullRequestEffectiveDiff diff) {
        ChangesCommandParameters parameters = ((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder().sinceId(diff.getSinceId()).untilId(diff.getUntilId()).maxChanges(this.maxChanges)).build();
        commandFactory.changes(parameters, (ChangeCallback)callback).call();
    }

    private DriftResult processPullRequestDiff(DriftContext context) {
        FileCommentDriftCallback callback = new FileCommentDriftCallback(context);
        if (callback.isEmpty()) {
            log.debug("{}: No file comment anchors to process", (Object)context.getPullRequest().getGlobalId());
            return callback.done();
        }
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)context.getRepository());
        PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
        InternalPullRequest pullRequest = context.getPullRequest();
        String timerName = "Drift: " + this.getName() + " - Diff-tree [" + currentDiff.getSinceId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
        try (Timer timer = TimerUtils.start((String)timerName);){
            this.processChanges(commandFactory, callback, currentDiff);
        }
        return callback.done();
    }

    private static class FileCommentDriftCallback
    extends AbstractChangeCallback {
        private final DriftResult driftResult = new DriftResult();
        private final Map<String, List<InternalPullRequestDiffCommentAnchor>> fileAnchorsByPath = Maps.newHashMap();

        FileCommentDriftCallback(DriftContext context) {
            for (InternalPullRequestDiffCommentAnchor anchor : context) {
                if (!anchor.isFileComment()) continue;
                FileCommentDriftCallback.addAnchorTo(anchor.getPath(), anchor, this.fileAnchorsByPath);
            }
        }

        public boolean onChange(@Nonnull Change change) throws IOException {
            this.driftResult.retain(this.getMatchingAnchors(change));
            return true;
        }

        public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
            this.driftResult.orphan(Iterables.concat(this.fileAnchorsByPath.values()));
            this.fileAnchorsByPath.clear();
        }

        DriftResult done() {
            if (!this.isEmpty()) {
                throw new IllegalStateException("This context should be empty after processing all changes");
            }
            return this.driftResult;
        }

        boolean isEmpty() {
            return this.fileAnchorsByPath.isEmpty();
        }

        private static void addAnchorTo(String key, InternalPullRequestDiffCommentAnchor anchor, Map<String, List<InternalPullRequestDiffCommentAnchor>> anchorMap) {
            if (!anchorMap.containsKey(key)) {
                anchorMap.put(key, Lists.newArrayList());
            }
            anchorMap.get(key).add(anchor);
        }

        private Iterable<InternalPullRequestDiffCommentAnchor> getMatchingAnchors(Change change) {
            List<InternalPullRequestDiffCommentAnchor> matching = this.fileAnchorsByPath.remove(change.getPath().toString());
            return matching != null ? matching : Collections.emptyList();
        }
    }
}

