/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pullRequestParticipantHelper")
public class InternalPullRequestParticipantHelper {
    private final StashAuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final PullRequestParticipantDao participantDao;
    private final InternalWatcherService watcherService;

    @Autowired
    public InternalPullRequestParticipantHelper(StashAuthenticationContext authenticationContext, EventPublisher eventPublisher, PullRequestParticipantDao participantDao, InternalWatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.participantDao = participantDao;
        this.watcherService = watcherService;
    }

    @Nonnull
    public InternalPullRequestParticipant makeCurrentUserParticipantAndWatcher(InternalPullRequest pullRequest) {
        StashUser user = this.authenticationContext.getCurrentUser();
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId().longValue(), user.getId().intValue());
        if (participant == null) {
            participant = (InternalPullRequestParticipant)this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
            this.fireParticipantAdded(pullRequest, user);
            this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, user);
        }
        return participant;
    }

    private void fireParticipantAdded(InternalPullRequest pullRequest, StashUser user) {
        this.eventPublisher.publish((Object)new PullRequestParticipantsUpdatedEvent((Object)this, (PullRequest)pullRequest, Collections.singleton(user), Collections.emptySet()));
    }
}

