/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.migration;

import com.atlassian.fugue.Option;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import javax.annotation.Nonnull;

public class FinalizeMigrationStep
extends AbstractMaintenanceTask {
    private final ConfigurationService configurationService;
    private final I18nService i18nService;
    private volatile int progress;
    private final MigrationState state;

    public FinalizeMigrationStep(MigrationState state, ConfigurationService configurationService, I18nService i18nService) {
        this.configurationService = configurationService;
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.migration.finalizing", new Object[0]), this.progress);
    }

    public void run() {
        DataSourceConfiguration configuration = this.state.getTargetDatabase().getConfiguration();
        String message = "Migrated to database at " + configuration.getUrl();
        this.configurationService.saveDataSourceConfiguration(configuration, Option.some((Object)message));
        this.state.getSourceDatabase().close();
        this.progress = 100;
    }
}

