/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatusSupplier;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMaintenanceTaskStatusSupplier
implements MaintenanceTaskStatusSupplier {
    private static final Logger log = LoggerFactory.getLogger(LocalMaintenanceTaskStatusSupplier.class);
    private final AtomicReference<MaintenanceTaskStatus> statusRef = new AtomicReference();

    @Override
    public MaintenanceTaskStatus get() {
        return this.statusRef.get();
    }

    @Override
    public void set(@Nonnull MaintenanceTaskStatus status) {
        MaintenanceTaskStatus existing;
        Preconditions.checkNotNull((Object)status, (Object)"status");
        do {
            if ((existing = this.statusRef.get()) == null || existing.getId().equals(status.getId()) || !existing.getStartTime().after(status.getStartTime())) continue;
            log.warn("Ignoring maintenance task status {} as existing status {} is newer", (Object)status, (Object)existing);
            break;
        } while (!this.statusRef.compareAndSet(existing, status));
    }
}

