/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.event.RemoveEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.IncorrectTokenMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.SystemMaintenanceEvent;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaintenanceLock
implements MaintenanceLock {
    private static final Logger log = LoggerFactory.getLogger(DefaultMaintenanceLock.class);
    private final SystemMaintenanceEvent event;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ExecutionList listeners;
    private final StashUser owner;
    private final String token;
    private volatile boolean locked;

    public DefaultMaintenanceLock(EventPublisher eventPublisher, I18nService i18nService, StashUser owner, String token) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.i18nService = i18nService;
        this.owner = (StashUser)Preconditions.checkNotNull((Object)owner, (Object)"owner");
        this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        this.event = new SystemMaintenanceEvent(EventType.get((String)"performing-maintenance"), "The system is unavailable while maintenance is being performed.", EventLevel.get((String)"system-maintenance"), token);
        this.listeners = new ExecutionList();
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Nonnull
    public StashUser getOwner() {
        return this.owner;
    }

    @Nonnull
    public String getUnlockToken() {
        return this.token;
    }

    public void lock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Already locked");
        this.locked = true;
        this.eventPublisher.publish((Object)new AddEvent((Object)this, (Event)this.event));
    }

    public void unlock(@Nonnull String token) {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Preconditions.checkState((boolean)this.locked, (Object)"Not locked");
        if (!this.event.isToken(token)) {
            log.warn("An invalid token ({}) was supplied to attempt to unlock the system", (Object)token);
            throw new IncorrectTokenMaintenanceException(this.i18nService.createKeyedMessage("stash.service.maintenance.lock.incorrectunlocktoken", new Object[0]), token);
        }
        this.eventPublisher.publish((Object)new RemoveEvent((Object)this, (Event)this.event));
        log.info("Maintenance has been completed. The system lock has been released");
        this.listeners.execute();
    }
}

