/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.concurrent.BucketProcessor;
import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.internal.idx.HierarchyIndexingRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.EscalatedSecurityContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HierarchyIndexer
implements BucketProcessor<HierarchyIndexingRequest> {
    private static final Logger log = LoggerFactory.getLogger(HierarchyIndexer.class);
    private final ChangesetIndexingService indexingService;
    private final RepositoryService repositoryService;
    private final EscalatedSecurityContext withRepoRead;

    @Autowired
    public HierarchyIndexer(ChangesetIndexingService indexingService, RepositoryService repositoryService, SecurityService securityService) {
        this.indexingService = indexingService;
        this.repositoryService = repositoryService;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "changeset indexing");
    }

    public void process(@Nonnull String hierarchyId, final @Nonnull List<HierarchyIndexingRequest> requests) {
        this.withRepoRead.call((Operation)new UncheckedOperation<Object>(){

            public Void perform() {
                for (HierarchyIndexingRequest request : requests) {
                    Repository repository = HierarchyIndexer.this.repositoryService.getById(request.getRepositoryId());
                    if (repository == null) {
                        log.info("[{}] Skipping indexing; it appears the repository has been deleted", (Object)request.getRepositoryId());
                        continue;
                    }
                    try {
                        HierarchyIndexer.this.indexingService.indexRepository(repository);
                    }
                    catch (Throwable t) {
                        if (HierarchyIndexer.this.indexingService.isActive()) {
                            log.error("[{}] Indexing failed", (Object)repository, (Object)t);
                            continue;
                        }
                        log.info("[{}] Indexing was aborted", (Object)repository);
                    }
                }
                return null;
            }
        });
    }
}

