/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.fugue.Effect;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.exception.ChangesetIndexingException;
import com.atlassian.stash.exception.NoSuchResourceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.idx.ChangesetIndexer;
import com.atlassian.stash.idx.CommitIndex;
import com.atlassian.stash.idx.CommitIndexer;
import com.atlassian.stash.idx.IndexingContext;
import com.atlassian.stash.internal.idx.BlockingChangesetQueueCallback;
import com.atlassian.stash.internal.idx.ChangesetIndexerStateDao;
import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.internal.idx.CommitChangesetIndexer;
import com.atlassian.stash.internal.idx.DefaultIndexingContext;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.internal.util.TransactionBatcher;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositorySupplier;
import com.atlassian.stash.scm.AsyncCommand;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service(value="changesetIndexingService")
public class DefaultChangesetIndexingService
implements ChangesetIndexingService {
    private static final String MANUALLY_REGISTERED = "manual-indexers";
    private static final Function<ChangesetIndexer, String> TO_ID = new Function<ChangesetIndexer, String>(){

        public String apply(ChangesetIndexer input) {
            return input.getId();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultChangesetIndexingService.class);
    private final CommitIndex commitIndex;
    private final I18nService i18nService;
    private final Multimap<String, ChangesetIndexer> indexers;
    private final ChangesetIndexerStateDao indexerStateDao;
    private final RepositorySupplier repositorySupplier;
    private final ScmService scmService;
    private final RepositorySnapshotService snapshotService;
    private final PlatformTransactionManager transactionManager;
    private volatile boolean active;
    @Value(value="${indexing.job.batch.size}")
    private int indexBatchSize;
    @Value(value="${indexing.process.timeout.execution}")
    private long timeoutSeconds;

    @Autowired
    public DefaultChangesetIndexingService(CommitIndex commitIndex, I18nService i18nService, ChangesetIndexerStateDao indexerStateDao, RepositorySupplier repositorySupplier, ScmService scmService, RepositorySnapshotService snapshotService, PlatformTransactionManager transactionManager) {
        this.commitIndex = commitIndex;
        this.i18nService = i18nService;
        this.indexerStateDao = indexerStateDao;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.snapshotService = snapshotService;
        this.transactionManager = transactionManager;
        this.active = true;
        this.indexers = HashMultimap.create((int)2, (int)1);
    }

    @Override
    public void indexRepository(@Nonnull Repository repository) {
        log.debug("[{}] Request for indexing received", (Object)repository);
        if (!this.active) {
            log.info("[{}] Skipping indexing; indexing has been shut down", (Object)repository);
            return;
        }
        List<ChangesetIndexer> enabledIndexers = this.getEnabledIndexers(repository);
        if (enabledIndexers.isEmpty()) {
            log.debug("[{}] Skipping indexing; no enabled indexers found", (Object)repository);
            return;
        }
        new IndexOperation(repository, enabledIndexers).perform();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @PreDestroy
    public void onDestroy() {
        this.active = false;
        log.debug("IndexingService is shutting down. Running indexing jobs will be aborted");
    }

    @PluginEventListener
    public synchronized void onPluginDisabled(PluginDisabledEvent event) {
        this.indexers.removeAll((Object)event.getPlugin().getKey());
    }

    @PluginEventListener
    public synchronized void onPluginEnabled(PluginEnabledEvent event) {
        ChangesetIndexer indexer;
        String moduleKey;
        Plugin plugin = event.getPlugin();
        String pluginKey = plugin.getKey();
        for (ModuleDescriptor module : plugin.getModuleDescriptorsByModuleClass(ChangesetIndexer.class)) {
            moduleKey = module.getKey();
            indexer = (ChangesetIndexer)module.getModule();
            if (indexer == null) {
                log.warn("Ignoring module {}:{}; the ChangesetIndexer was null", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            if (indexer.getId() == null) {
                log.warn("Ignoring module {}:{}; the ChangesetIndexer does not define an ID", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            log.debug("Registering module {}:{} as a ChangesetIndexer", (Object)pluginKey, (Object)moduleKey);
            this.indexers.put((Object)pluginKey, (Object)indexer);
        }
        for (ModuleDescriptor module : plugin.getModuleDescriptorsByModuleClass(CommitIndexer.class)) {
            moduleKey = module.getKey();
            indexer = (CommitIndexer)module.getModule();
            if (indexer == null) {
                log.warn("Ignoring module {}:{}; the CommitIndexer was null", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            if (indexer.getId() == null) {
                log.warn("Ignoring module {}:{}; the CommitIndexer does not define an ID", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            log.debug("Registering module {}:{} as a CommitIndexer", (Object)pluginKey, (Object)moduleKey);
            this.indexers.put((Object)pluginKey, (Object)new CommitChangesetIndexer((CommitIndexer)indexer));
        }
    }

    @VisibleForTesting
    synchronized Collection<ChangesetIndexer> getIndexers() {
        return Collections.unmodifiableCollection(this.indexers.values());
    }

    @VisibleForTesting
    synchronized void register(ChangesetIndexer indexer) {
        this.indexers.put((Object)MANUALLY_REGISTERED, (Object)indexer);
    }

    @VisibleForTesting
    void setIndexBatchSize(int indexBatchSize) {
        this.indexBatchSize = indexBatchSize;
    }

    private AsyncCommand<Void> changesetsAdded(Repository repository, Long lastIndexingRun, long thisIndexingRun, ChangesetCallback callback) {
        Iterable<String> currentIndexingHeads = this.snapshotService.create(repository, thisIndexingRun);
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        return this.changesetsBetween(repository, currentIndexingHeads, lastIndexingHeads, callback);
    }

    private AsyncCommand<Void> changesetsBetween(Repository repository, Iterable<String> includedHeads, Iterable<String> excludedHeads, ChangesetCallback callback) {
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
        CommitsCommandParameters parameters = new CommitsCommandParameters.Builder().include(includedHeads).exclude(excludedHeads).build();
        return commandFactory.commits(parameters, callback).asynchronous();
    }

    private AsyncCommand<Void> changesetsRemoved(Repository repository, Long lastIndexingRun, long thisIndexingRun, ChangesetCallback callback) {
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        Iterable<String> currentIndexingHeads = this.snapshotService.getByRepository(repository, thisIndexingRun);
        return this.changesetsBetween(repository, lastIndexingHeads, currentIndexingHeads, callback);
    }

    private synchronized List<ChangesetIndexer> getEnabledIndexers(final Repository repository) {
        if (this.indexers.isEmpty()) {
            return Collections.emptyList();
        }
        return Chainable.chain((Iterable)this.indexers.values()).filter((Predicate)new Predicate<ChangesetIndexer>(){

            public boolean apply(ChangesetIndexer changesetIndexer) {
                return changesetIndexer.isEnabledForRepository(repository);
            }
        }).toList();
    }

    private Iterable<String> getIndexedHeadsOrEmpty(Repository repository, Long timestamp) {
        try {
            return this.snapshotService.getByRepository(repository, timestamp);
        }
        catch (NoSuchResourceException e) {
            log.info("{} The snapshot for the previous indexing run could not be found. Indexing will start from the start of the commit history.", (Object)repository);
            return Collections.emptySet();
        }
    }

    private class IndexOperation
    implements UncheckedOperation<Void> {
        private final List<ChangesetIndexer> enabledIndexers;
        private final int repositoryId;
        private final String identifier;

        private IndexOperation(Repository repository, List<ChangesetIndexer> enabledIndexers) {
            this.enabledIndexers = Lists.newArrayList(enabledIndexers);
            this.identifier = "[" + repository.toString() + "]";
            this.repositoryId = repository.getId();
        }

        public Void perform() {
            this.index();
            return null;
        }

        private long calculateTimeout() {
            return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(DefaultChangesetIndexingService.this.timeoutSeconds);
        }

        private void eachIndexer(Iterable<ChangesetIndexer> indexers, Effect<ChangesetIndexer> effect) {
            Iterator<ChangesetIndexer> it = indexers.iterator();
            while (it.hasNext()) {
                ChangesetIndexer indexer = it.next();
                try {
                    effect.apply((Object)indexer);
                }
                catch (Exception e) {
                    it.remove();
                    log.warn("Changeset indexer {} caused an error '{}' and has been disabled for the remainder of this indexing run. Enable debug logging to see the exception details.", (Object)indexer.getId(), (Object)StringUtils.defaultString((String)e.getMessage()));
                    log.debug("Changeset indexer error:", (Throwable)e);
                }
            }
        }

        private String formatBatchId(int fromBatch) {
            return this.identifier + " indexChangesetBatch(" + fromBatch + ".." + (fromBatch + DefaultChangesetIndexingService.this.indexBatchSize) + ")";
        }

        private void handleTimeout(Future<Void> future, long timeoutTimestamp) {
            long now = System.currentTimeMillis();
            if (this.isTimeoutConfigured() && now > timeoutTimestamp) {
                log.info("{} Indexing SCM process has timed out, wrapping up the process", (Object)this.identifier);
                try {
                    future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    log.debug(this.identifier + " An unexpected exception was thrown while processing an SCM timeout", (Throwable)e);
                }
                catch (TimeoutException e) {
                    KeyedMessage message = DefaultChangesetIndexingService.this.i18nService.createKeyedMessage("stash.service.changesetindexing.timeout", new Object[]{this.identifier, DefaultChangesetIndexingService.this.timeoutSeconds});
                    throw new ChangesetIndexingException(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void index() {
            if (log.isDebugEnabled()) {
                log.debug("{} Starting indexing with indexers [{}]", (Object)this.identifier, (Object)StringUtils.join((Collection)Lists.transform(this.enabledIndexers, (Function)TO_ID), (String)", "));
            }
            TransactionBatcher batch = new TransactionBatcher(DefaultChangesetIndexingService.this.transactionManager, DefaultChangesetIndexingService.this.indexBatchSize, this.identifier);
            try (Timer timer = TimerUtils.start((String)(this.identifier + " index repository"));){
                batch.start();
                Repository repository = DefaultChangesetIndexingService.this.repositorySupplier.getById(this.repositoryId);
                if (repository == null) {
                    log.info("{} Skipping indexing; it appears the repository has been deleted", (Object)this.identifier);
                    return;
                }
                DefaultIndexingContext ctx = new DefaultIndexingContext(repository);
                ArrayList activeIndexers = Lists.newArrayList(this.enabledIndexers);
                this.notifyOnBefore(activeIndexers, ctx);
                if (activeIndexers.isEmpty()) {
                    log.debug("{} Skipping indexing; all enabled indexers have failed", (Object)this.identifier);
                    return;
                }
                Long lastIndexingRunTimestamp = DefaultChangesetIndexingService.this.indexerStateDao.getOldestLastRunTimestamp(repository, (Iterable)activeIndexers);
                if (lastIndexingRunTimestamp == null && DefaultChangesetIndexingService.this.scmService.isEmpty(repository)) {
                    log.debug("{} Skipping indexing for empty repository", (Object)this.identifier);
                    batch.commit();
                    return;
                }
                long thisIndexingRunTimestamp = System.currentTimeMillis();
                BlockingChangesetQueueCallback changesetQueue = new BlockingChangesetQueueCallback(1024);
                AsyncCommand addCommand = DefaultChangesetIndexingService.this.changesetsAdded(repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, (ChangesetCallback)changesetQueue);
                repository = this.indexChangesets((AsyncCommand<Void>)addCommand, batch, repository, ctx, activeIndexers, changesetQueue, true);
                if (!DefaultChangesetIndexingService.this.active) {
                    return;
                }
                log.debug("{} Scanning for deleted changesets...", (Object)this.identifier);
                changesetQueue.clear();
                AsyncCommand delCommand = DefaultChangesetIndexingService.this.changesetsRemoved(repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, (ChangesetCallback)changesetQueue);
                repository = this.indexChangesets((AsyncCommand<Void>)delCommand, batch, repository, ctx, activeIndexers, changesetQueue, false);
                if (!DefaultChangesetIndexingService.this.active) {
                    return;
                }
                DefaultChangesetIndexingService.this.indexerStateDao.setLastRunTimestamp(repository, (Iterable)activeIndexers, thisIndexingRunTimestamp);
                DefaultChangesetIndexingService.this.snapshotService.pruneByRepository(repository, DefaultChangesetIndexingService.this.indexerStateDao.getReferencedLastRunTimestamps(repository));
                batch.commit();
                this.notifyOnAfter(this.enabledIndexers, ctx);
                return;
            }
            catch (NoSuchResourceException | ConstraintViolationException | DataIntegrityViolationException e) {
                log.info("{} Repository was deleted during indexing. Indexing is aborted");
                return;
            }
            catch (IllegalStateException e) {
                log.info("{} Application shutdown during indexing. Indexing is aborted");
                return;
            }
            finally {
                if (batch.rollback()) {
                    log.info("{} Rolled back indexing transaction", (Object)this.identifier);
                }
                log.debug("{} Indexed {} changesets", (Object)this.identifier, (Object)batch.getCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Repository indexChangesets(AsyncCommand<Void> command, TransactionBatcher batch, Repository repo, final IndexingContext ctx, List<ChangesetIndexer> activeIndexers, BlockingChangesetQueueCallback changesetQueue, final boolean add) {
            Future result = command.start();
            long timeoutTimestamp = this.calculateTimeout();
            try (Timer timer = TimerUtils.start((String)this.formatBatchId(batch.getCount()));){
                Changeset changeset;
                while (DefaultChangesetIndexingService.this.active && (changeset = changesetQueue.poll(5L, TimeUnit.SECONDS)) != null) {
                    this.handleTimeout(result, timeoutTimestamp);
                    if (add) {
                        DefaultChangesetIndexingService.this.commitIndex.addChangeset(changeset, repo);
                    } else {
                        DefaultChangesetIndexingService.this.commitIndex.removeChangeset(changeset.getId(), repo);
                    }
                    final Changeset cs = changeset;
                    this.eachIndexer(activeIndexers, new Effect<ChangesetIndexer>(){

                        public void apply(ChangesetIndexer indexer) {
                            if (add) {
                                indexer.onChangesetAdded(cs, ctx);
                            } else {
                                indexer.onChangesetRemoved(cs, ctx);
                            }
                        }
                    });
                    if (batch.tick()) {
                        timer.mark(this.formatBatchId(batch.getCount()));
                        log.debug("{} Completed batch, Indexed {} so far", (Object)this.identifier, (Object)batch.getCount());
                        repo = DefaultChangesetIndexingService.this.repositorySupplier.getById(repo.getId().intValue());
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("{} Processed {} - {}", new Object[]{this.identifier, changeset.getId(), batch.getCount()});
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("{} Indexing was interrupted", (Object)this.identifier);
            }
            finally {
                this.wrapUpCommand(result);
            }
            return repo;
        }

        private boolean isTimeoutConfigured() {
            return DefaultChangesetIndexingService.this.timeoutSeconds > 0L;
        }

        private void notifyOnBefore(List<ChangesetIndexer> indexers, final IndexingContext ctx) {
            try (Timer timer = TimerUtils.start((String)(this.identifier + " onBeforeIndexing"));){
                this.eachIndexer(indexers, new Effect<ChangesetIndexer>(){

                    public void apply(ChangesetIndexer indexer) {
                        indexer.onBeforeIndexing(ctx);
                    }
                });
            }
        }

        private void notifyOnAfter(List<ChangesetIndexer> indexers, final IndexingContext ctx) {
            try (Timer timer = TimerUtils.start((String)(this.identifier + " onAfterIndexing"));){
                this.eachIndexer(indexers, new Effect<ChangesetIndexer>(){

                    public void apply(ChangesetIndexer indexer) {
                        indexer.onAfterIndexing(ctx);
                    }
                });
            }
        }

        private void wrapUpCommand(Future<Void> result) {
            log.trace("{} Waiting for SCM command to wrap up", (Object)this.identifier);
            try {
                result.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.debug("{} SCM command did not finish on its own, canceling process", (Object)this.identifier);
                result.cancel(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug(this.identifier + " Interrupted while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
            catch (ExecutionException e) {
                log.debug(this.identifier + " Exception happened while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
        }
    }
}

