/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.help.HelpPathService;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.help.AbstractHelpPathService;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import java.util.Iterator;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HelpPathService.class)
@Component(value="helpPathService")
public class I18nHelpPathService
extends AbstractHelpPathService {
    private final I18nService i18nService;
    private final LocaleHolder localeHolder;

    @Autowired
    public I18nHelpPathService(I18nService i18nService, LocaleHolder localeHolder) {
        this.localeHolder = localeHolder;
        this.i18nService = i18nService;
    }

    protected String getProperty(String key) {
        return this.i18nService.getMessage(key, new Object[0]);
    }

    public String getPageUrl(String topicKey) {
        String url = super.getPageUrl(topicKey);
        return url != null ? url + this.getQueryParams() : null;
    }

    private String getQueryParams() {
        Locale l;
        StringBuilder b = new StringBuilder();
        String en = Locale.ENGLISH.getLanguage();
        Iterator i$ = this.localeHolder.getLocales(new Locale[0]).iterator();
        while (i$.hasNext() && !en.equals((l = (Locale)i$.next()).getLanguage())) {
            b.append(l);
            b.append(",");
        }
        return b.length() == 0 ? "" : "?locale=" + b.substring(0, b.length() - 1);
    }
}

