/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PropertyFeatureManager
implements FeatureManager {
    static final String PROP_PREFIX = "feature.";
    private final Set<Feature> enabledFeatures;

    @Autowired
    public PropertyFeatureManager(@Qualifier(value="applicationProperties") Properties applicationProperties) {
        this.enabledFeatures = PropertyFeatureManager.loadEnabledFeatures(applicationProperties);
    }

    public boolean isEnabled(@Nonnull Feature feature) {
        Preconditions.checkNotNull((Object)feature);
        return this.enabledFeatures.contains(feature);
    }

    private static Set<Feature> loadEnabledFeatures(Properties properties) {
        EnumSet<Feature> enabledFeatures = EnumSet.noneOf(Feature.class);
        for (Feature feature : Feature.values()) {
            if (!Boolean.parseBoolean(properties.getProperty(PROP_PREFIX + feature.getKey()))) continue;
            enabledFeatures.add(feature);
        }
        return enabledFeatures;
    }
}

