/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

class DataSourceConfigAmendment {
    private final Clock clock;
    private final DataSourceConfiguration dataSourceConfig;
    private final Option<String> message;
    private final StashUser stashUser;

    DataSourceConfigAmendment(@Nonnull DataSourceConfiguration dataSourceConfig, @Nonnull Option<String> message, @Nonnull Clock clock, @Nullable StashUser stashUser) {
        this.dataSourceConfig = (DataSourceConfiguration)Preconditions.checkNotNull((Object)dataSourceConfig);
        this.message = (Option)Preconditions.checkNotNull(message);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.stashUser = stashUser;
    }

    void writeTo(@Nonnull BufferedWriter writer) {
        try {
            this.writeCommentBlock(writer);
            this.writePropertyStrings(writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to amend database configuration", e);
        }
    }

    private String updateStamp() {
        StringBuilder builder = new StringBuilder("#> Updated");
        if (this.stashUser != null) {
            builder.append(" by ").append(this.stashUser.getDisplayName());
        }
        builder.append(" on ").append(ISODateTimeFormat.dateTime().print((ReadableInstant)this.clock.now()));
        return builder.toString();
    }

    private void writeCommentBlock(Writer writer) throws IOException {
        DataSourceConfigAmendment.writeLine(writer, "#>*******************************************************");
        if (this.message.isDefined()) {
            DataSourceConfigAmendment.writeLine(writer, "#> " + (String)this.message.get());
        }
        DataSourceConfigAmendment.writeLine(writer, this.updateStamp());
        DataSourceConfigAmendment.writeLine(writer, "#>*******************************************************");
    }

    private void writePropertyStrings(Writer writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.dataSourceConfig);
        serializer.writeTo(writer);
    }

    private static void writeLine(Writer writer, String text) throws IOException {
        writer.write(text + '\n');
    }
}

