/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.concurrent.RepositoryLock;
import com.atlassian.stash.internal.concurrent.ClusterMappedLock;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.Operation;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import javax.annotation.Nonnull;

public class HazelcastRepositoryLock
implements RepositoryLock {
    private static final String LOCK_PREFIX = "lock.stash.repository.";
    private final ClusterMappedLock lock;

    public HazelcastRepositoryLock(HazelcastInstance hazelcastInstance, String lockName) {
        this.lock = new ClusterMappedLock(hazelcastInstance, LOCK_PREFIX + lockName);
    }

    public <T, E extends Exception> T withLock(@Nonnull Integer repositoryId, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(((Integer)Preconditions.checkNotNull((Object)repositoryId, (Object)"repositoryId")).toString(), operation);
    }

    public <T, E extends Exception> T withLock(@Nonnull Repository repository, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId().toString(), operation);
    }
}

