/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.concurrent.LockService;
import com.atlassian.stash.concurrent.PullRequestLock;
import com.atlassian.stash.concurrent.RepositoryLock;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.HazelcastPullRequestLock;
import com.atlassian.stash.internal.concurrent.HazelcastRepositoryLock;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LockService.class)
@Service(value="lockService")
public class DefaultLockService
implements LockService {
    private final ClusterLockService clusterLockService;
    private final HazelcastInstance hazelcast;

    @Autowired
    public DefaultLockService(ClusterLockService clusterLockService, HazelcastInstance hazelcast) {
        this.clusterLockService = clusterLockService;
        this.hazelcast = hazelcast;
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public Lock getLock(@Nonnull String lockName) {
        return this.clusterLockService.getLockForName((String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public PullRequestLock getPullRequestLock(@Nonnull String lockName) {
        return new HazelcastPullRequestLock(this.hazelcast, (String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public RepositoryLock getRepositoryLock(@Nonnull String lockName) {
        return new HazelcastRepositoryLock(this.hazelcast, (String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }
}

