/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.hazelcast.core.PartitionAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

class BucketKey
implements PartitionAware<String>,
DataSerializable {
    private String bucketId;
    private String executorName;

    public BucketKey() {
    }

    public BucketKey(String executorName, String bucketId) {
        this.bucketId = bucketId;
        this.executorName = executorName;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getPartitionKey() {
        return this.bucketId;
    }

    public void readData(ObjectDataInput objectDataInput) throws IOException {
        this.executorName = objectDataInput.readUTF();
        this.bucketId = objectDataInput.readUTF();
    }

    public String toString() {
        return this.executorName + "@" + this.bucketId;
    }

    public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        objectDataOutput.writeUTF(this.executorName);
        objectDataOutput.writeUTF(this.bucketId);
    }
}

