/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.util.contentcache.ContentProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class TimedContentProvider
implements ContentProvider {
    private final String name;
    private final ContentProvider delegate;

    public TimedContentProvider(String name, ContentProvider delegate) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.name = name;
        this.delegate = delegate;
    }

    public void apply(OutputStream out) throws IOException {
        try (Timer timer = TimerUtils.start((String)this.name);){
            this.delegate.apply(out);
        }
    }

    public Date getExpiry() {
        return this.delegate.getExpiry();
    }
}

