/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.cluster.ClusterInformation;
import com.atlassian.stash.cluster.ClusterNode;
import com.atlassian.stash.internal.cluster.HazelcastClusterNode;
import com.google.common.base.Preconditions;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import java.util.Set;
import javax.annotation.Nonnull;

public class HazelcastClusterInformation
implements ClusterInformation {
    private final Cluster cluster;
    private final HazelcastInstance hazelcast;

    public HazelcastClusterInformation(HazelcastInstance hazelcast) {
        this.hazelcast = (HazelcastInstance)Preconditions.checkNotNull((Object)hazelcast, (Object)"hazelcast");
        this.cluster = (Cluster)Preconditions.checkNotNull((Object)hazelcast.getCluster(), (Object)"hazelcast.cluster");
    }

    @Nonnull
    public ClusterNode getLocalNode() {
        return new HazelcastClusterNode(this.cluster.getLocalMember());
    }

    @Nonnull
    public Set<ClusterNode> getNodes() {
        return HazelcastClusterNode.sort(HazelcastClusterNode.transform(this.cluster.getMembers()));
    }

    public boolean isRunning() {
        return this.hazelcast.getLifecycleService().isRunning();
    }
}

