/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.license.SIDManager;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.bootstrap.Bootstrapper;
import com.atlassian.stash.internal.profiles.Dev;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Dev
@Component(value="bootstrapper")
public class DevBootstrapper
extends Bootstrapper {
    private static final List<UserData> ADMINISTRATORS = ImmutableList.of((Object)new UserData("admin", "Ad", "Min", "Administrator"));
    private static final String LICENSE_CLUSTERED = "AAABAA0ODAoPeNptUE1Lw0AUvPdXLHhOybZGsbCgpiE2aJrSDZ6f8dUuJJvy3ibYf2+M22LF63wxM\n1ev+C6yzgopRXi3iORiFopkq8UslNcTdsD7adJD3YEzrVU7qBk9HBOO4BIcqm95EN4EUp7Y1jqoX\nA4NqgdXA7MBKzSyQ/KSFzDWoQVbYfJ5MHQck4r5k+cHu+lROerwMjQZnLVyY9Y9nMKnVdt43bOp0\nDLq4wHHAnpYtMrTyRapR1ot1WNWboLNPNZBWmZRoKPb1FsLIGeRRpuH1vQB1vDPA+ctnhw6Q4zDD\nvpdNO+aN6T1rmQkVnJ22evftUVH1R4Y/975BcASkF4wLQIVAJHuXZz1SsymUm2B5V7p7Pap48xzA\nhROyzM1l9a1OqcWzxseRNmnZ4XqmQ==X02d9";
    private static final Logger log = LoggerFactory.getLogger(DevBootstrapper.class);
    private static final List<UserData> USERS = ImmutableList.of((Object)new UserData("user", "U", "Ser", "User"));
    private final LicenseService licenseService;
    private final UserService userService;

    @Autowired
    public DevBootstrapper(ApplicationManager appManager, DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, SecurityService securityService, GlobalPermissionDao globalPermissionDao, SIDManager sidManager, LicenseService licenseService, UserService userService, PlatformTransactionManager transactionManager) {
        super(appManager, directoryManager, propertiesService, securityService, sidManager, globalPermissionDao, transactionManager);
        this.licenseService = licenseService;
        this.userService = userService;
    }

    @Override
    protected void addUsers(Directory dir) throws CrowdException, PermissionException {
        Long dirId = dir.getId();
        StashLicense license = this.licenseService.get();
        int licensedUsers = 0;
        for (UserData data : ADMINISTRATORS) {
            this.addUser(data.username, data.firstName, data.lastName, data.name, dirId, new String[0]);
            StashUser user = this.userService.getUserByName(data.username, true);
            this.addPermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(Permission.SYS_ADMIN)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
            ++licensedUsers;
        }
        for (UserData data : USERS) {
            this.addUser(data.username, data.firstName, data.lastName, data.name, dirId, new String[0]);
            if (licensedUsers < license.getMaximumNumberOfUsers()) {
                this.directoryManager.addUserToGroup(dirId.longValue(), data.username, "stash-users");
                ++licensedUsers;
                continue;
            }
            log.warn("Not adding {} to {}; there are already {} licensed users", new Object[]{data.username, "stash-users", licensedUsers});
        }
    }

    @Override
    @Transactional
    public synchronized void bootstrap() {
        this.licenseService.set(LICENSE_CLUSTERED);
        super.bootstrap();
        this.disableFirstRunWizard();
    }

    @Override
    protected void ensureMinimalApplicationProperties() {
        super.ensureMinimalApplicationProperties();
        if (this.propertiesService.getBaseUrl() == null) {
            this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)String.format("http://%s:7990/stash", this.getBaseUrlMachineName())));
        }
    }

    private String getBaseUrlMachineName() {
        try {
            if (this.initBaseUrlWithMachineHost()) {
                return InetAddress.getLocalHost().getHostName().toLowerCase(Locale.US);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "localhost";
    }

    private boolean initBaseUrlWithMachineHost() {
        return Boolean.getBoolean("stash.dev.init.baseurl.with.machine.host");
    }

    private static class UserData {
        private final String firstName;
        private final String lastName;
        private final String name;
        private final String username;

        private UserData(String username, String firstName, String lastName, String name) {
            this.username = username;
            this.firstName = firstName;
            this.lastName = lastName;
            this.name = name;
        }
    }
}

