/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.external;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginContainerUnavailableEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginModuleAvailableEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleUnavailableEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.internal.audit.AbstractAuditEventPublisher;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginEventListener
extends AbstractAuditEventPublisher {
    @Autowired
    public PluginEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onPluginContainerUnavailable(PluginContainerUnavailableEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getPluginKey()).build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getPlugin().getKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getPlugin().getKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target("Plugin Framework").build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    @EventListener
    public void onPluginModuleAvailable(PluginModuleAvailableEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getModule().getCompleteKey()).build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getModule().getCompleteKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getModule().getCompleteKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginModuleUnavailable(PluginModuleUnavailableEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getModule().getCompleteKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginUninstalled(PluginUninstalledEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getPlugin().getKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    @EventListener
    public void onPluginUpgraded(PluginUpgradedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder(event).target(event.getPlugin().getKey()).build();
        this.publish(event, auditEntry, Priority.MEDIUM);
    }

    private AuditEntry.Builder createAuditEntryBuilder(Object event) {
        return this.setCommonFields(event, new AuditEntry.Builder());
    }
}

