/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.ProjectAvatarUpdatedEvent;
import com.atlassian.stash.event.ProjectCreatedEvent;
import com.atlassian.stash.event.ProjectCreationRequestedEvent;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.event.ProjectDeletionRequestedEvent;
import com.atlassian.stash.event.ProjectEvent;
import com.atlassian.stash.event.ProjectModifiedEvent;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectEventListener
extends AbstractAuditEventListener {
    @Autowired
    public ProjectEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).project(event.getProject()).details(this.convertToJsonString(ProjectEventListener.diffProjects(event.getOldValue(), event.getNewValue()))).target(event.getProject().getKey()).build();
        this.publish(event, auditEntry, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.project"}), Priority.HIGH);
    }

    @EventListener
    public void onProjectAvatarUpdated(ProjectAvatarUpdatedEvent event) throws Exception {
        this.auditProjectEvent((ProjectEvent)event);
    }

    @EventListener
    public void onProjectCreated(ProjectCreatedEvent event) throws Exception {
        this.auditProjectEvent((ProjectEvent)event, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.project"}), Priority.HIGH);
    }

    @EventListener
    public void onProjectCreationRequested(ProjectCreationRequestedEvent event) throws Exception {
        this.auditProjectEvent((ProjectEvent)event);
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) throws Exception {
        this.auditProjectEvent((ProjectEvent)event, Collections.emptySet(), Priority.HIGH);
    }

    @EventListener
    public void onProjectDeletionRequested(ProjectDeletionRequestedEvent event) throws Exception {
        this.auditProjectEvent((ProjectEvent)event);
    }

    private static Map<String, Object> diffProjects(Project old, Project updated) {
        LinkedHashMap differences = Maps.newLinkedHashMap();
        if (!StringUtils.equals((String)old.getKey(), (String)updated.getKey())) {
            differences.put("old.key", old.getKey());
            differences.put("new.key", updated.getKey());
        }
        if (!StringUtils.equals((String)old.getName(), (String)updated.getName())) {
            differences.put("old.name", old.getName());
            differences.put("new.name", updated.getName());
        }
        if (!StringUtils.equals((String)old.getDescription(), (String)updated.getDescription())) {
            differences.put("old.description", old.getDescription());
            differences.put("new.description", updated.getDescription());
        }
        if (old.isPublic() != updated.isPublic()) {
            differences.put("old.isPublic", old.isPublic());
            differences.put("new.isPublic", updated.isPublic());
        }
        return differences;
    }

    private void auditProjectEvent(ProjectEvent event) throws Exception {
        this.auditProjectEvent(event, Collections.emptySet(), Priority.LOW);
    }

    private void auditProjectEvent(ProjectEvent event, Set<String> channels, Priority priority) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).project(event.getProject()).target(event.getProject().getKey()).build();
        this.publish(event, auditEntry, channels, priority);
    }
}

