/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.event.permission.GlobalPermissionEvent;
import com.atlassian.stash.event.permission.PermissionEvent;
import com.atlassian.stash.event.permission.PermissionModifiedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionEvent;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionEventListener
extends AbstractAuditEventListener {
    static final String TARGET_GLOBAL = "Global";

    @Autowired
    public PermissionEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onGlobalPermission(GlobalPermissionEvent event) throws Exception {
        AuditEntry auditEntry = this.createPermissionAuditEntryBuilder((PermissionEvent)event).target(TARGET_GLOBAL).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onProjectPermission(ProjectPermissionEvent event) throws Exception {
        AuditEntry auditEntry = this.createPermissionAuditEntryBuilder((PermissionEvent)event).project(event.getProject()).target(event.getProject().getKey()).build();
        this.publish(event, auditEntry, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.project"}), Priority.HIGH);
    }

    @EventListener
    public void onRepositoryPermission(RepositoryPermissionEvent event) throws Exception {
        AuditEntry auditEntry = this.createPermissionAuditEntryBuilder((PermissionEvent)event).repository(event.getRepository()).target(PermissionEventListener.toProjectAndRepositoryString(event.getRepository())).build();
        this.publish(event, auditEntry, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.repository"}), Priority.HIGH);
    }

    private AuditEntry.Builder createPermissionAuditEntryBuilder(PermissionEvent event) throws IOException {
        ImmutableMap.Builder<String, Object> builder = PermissionEventListener.getMapBuilder();
        if (event instanceof PermissionModifiedEvent) {
            PermissionModifiedEvent modifiedEvent = (PermissionModifiedEvent)event;
            builder.put((Object)"old.permission", (Object)modifiedEvent.getOldValue());
            builder.put((Object)"new.permission", (Object)modifiedEvent.getNewValue());
        } else {
            builder.put((Object)"permission", (Object)event.getPermission().name());
        }
        if (event.getAffectedUser() == null && event.getAffectedGroup() == null) {
            builder.put((Object)"global", (Object)"true");
        } else {
            if (event.getAffectedUser() != null) {
                builder.put((Object)"user", (Object)event.getAffectedUser().getName());
            }
            if (event.getAffectedGroup() != null) {
                builder.put((Object)"group", (Object)event.getAffectedGroup());
            }
        }
        return this.createAuditEntryBuilder((StashEvent)event).details(this.convertToJsonString(builder.build()));
    }
}

