/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.audit.AuditEvent;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="auditEventListener")
public class AuditEventListener {
    private static final Logger log = LoggerFactory.getLogger(AuditEventListener.class);
    private final AuditEntryLoggingService service;
    private Priority priorityToFilter;

    @Autowired
    public AuditEventListener(AuditEntryLoggingService service) {
        this.service = service;
    }

    @Value(value="${audit.highest.priority.to.log}")
    public void setPriorityToLog(String priority) {
        try {
            this.priorityToFilter = Priority.valueOf((String)priority.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.priorityToFilter = Priority.HIGH;
            log.warn("The configured 'audit.highest.priority.to.log', '{}', is invalid; defaulting to '{}'.", (Object)priority, (Object)this.priorityToFilter);
        }
    }

    @EventListener
    public void onAuditEvent(AuditEvent event) {
        if (this.priorityToFilter == Priority.NONE) {
            return;
        }
        if (event.getPriority().getWeight() >= this.priorityToFilter.getWeight()) {
            this.service.log(event.getEntry());
        }
    }
}

