/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.internal.audit.AbstractAuditEventPublisher;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.util.AuditUtils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractAuditEventListener
extends AbstractAuditEventPublisher {
    public AbstractAuditEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    static ImmutableMap.Builder<String, Object> addProjectAndRepositoryToMap(@Nonnull Repository repository, ImmutableMap.Builder<String, Object> mapBuilder) {
        return mapBuilder.put((Object)"project", (Object)repository.getProject().getKey()).put((Object)"repository", (Object)repository.getSlug());
    }

    static ImmutableMap.Builder<String, Object> getMapBuilder() {
        return ImmutableMap.builder();
    }

    static <K, V> void safePut(ImmutableMap.Builder<K, V> builder, K key, V value) {
        if (key != null && value != null) {
            builder.put(key, value);
        }
    }

    static List<Map<String, Object>> toMaps(Collection<RefChange> refChanges) {
        ArrayList<Map<String, Object>> changesAsMaps = new ArrayList<Map<String, Object>>(refChanges.size());
        for (RefChange change : refChanges) {
            changesAsMaps.add((Map<String, Object>)AbstractAuditEventListener.getMapBuilder().put((Object)"ref", (Object)change.getRefId()).put((Object)"from", (Object)change.getFromHash()).put((Object)"to", (Object)change.getToHash()).build());
        }
        return changesAsMaps;
    }

    static Map<String, Object> toProjectAndRepositoryMap(@Nonnull Repository repository) {
        return AbstractAuditEventListener.addProjectAndRepositoryToMap(repository, AbstractAuditEventListener.getMapBuilder()).build();
    }

    static String toProjectAndRepositoryString(Repository repository) {
        return AuditUtils.toProjectAndRepositoryString((Repository)repository);
    }

    AuditEntry.Builder createAuditEntryBuilder(StashEvent event) {
        return this.setCommonFields(event, new AuditEntry.Builder()).user(event.getUser());
    }
}

