/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.experimental.user;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.stash.experimental.user.ResourcePermissionRequest;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@ExperimentalApi
public class RepositoryPermissionRequest
extends ResourcePermissionRequest {
    private final Repository repository;

    private RepositoryPermissionRequest(@Nonnull Builder builder) {
        super(builder);
        this.repository = (Repository)Preconditions.checkNotNull((Object)builder.repository, (Object)"repository");
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUser(), this.repository});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryPermissionRequest other = (RepositoryPermissionRequest)obj;
        return Objects.equal((Object)this.getUser(), (Object)other.getUser()) && Objects.equal((Object)this.repository, (Object)other.repository);
    }

    public static class Builder
    extends ResourcePermissionRequest.AbstractBuilder<Builder, RepositoryPermissionRequest> {
        private Repository repository;

        public Builder() {
        }

        public Builder(@Nonnull RepositoryPermissionRequest request) {
            super(request);
            this.repository = request.repository;
        }

        public Builder repository(@Nonnull Repository repository) {
            this.repository = repository;
            return this.self();
        }

        @Override
        public RepositoryPermissionRequest build() {
            return new RepositoryPermissionRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

