/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JohnsonUtils {
    public static final String EVENT_TYPE_NODE_PASSIVATED = "node-passivated";
    public static final String LEVEL_MAINTENANCE = "maintenance";
    public static final String LEVEL_SYSTEM_MAINTENANCE = "system-maintenance";
    private static final List<String> EVENT_LEVELS = ImmutableList.of((Object)"system-maintenance", (Object)"maintenance", (Object)"warning", (Object)"error", (Object)"fatal");

    private JohnsonUtils() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static String findHighestEventLevel(@Nonnull JohnsonEventContainer eventContainer) {
        int index = JohnsonUtils.findHighestEventLevelIndex(eventContainer);
        return index == -1 ? null : EVENT_LEVELS.get(index);
    }

    public static boolean isLevelAtLeast(@Nonnull String level, @Nonnull String minimumLevel) {
        int index = EVENT_LEVELS.indexOf(level);
        Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Invalid level %s", (Object[])new Object[]{level});
        int minimumIndex = EVENT_LEVELS.indexOf(minimumLevel);
        Preconditions.checkArgument((minimumIndex != -1 ? 1 : 0) != 0, (String)"Invalid minimumLevel %s", (Object[])new Object[]{minimumIndex});
        return minimumIndex <= index;
    }

    public static boolean isLevelAtMost(@Nonnull String level, @Nonnull String maximumLevel) {
        int index = EVENT_LEVELS.indexOf(level);
        Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Invalid level %s", (Object[])new Object[]{level});
        int maximumIndex = EVENT_LEVELS.indexOf(maximumLevel);
        Preconditions.checkArgument((maximumIndex != -1 ? 1 : 0) != 0, (String)"Invalid maximumLevel %s", (Object[])new Object[]{maximumLevel});
        return maximumIndex >= index;
    }

    private static int findHighestEventLevelIndex(JohnsonEventContainer eventContainer) {
        int i = -1;
        for (Event event : eventContainer.getEvents()) {
            int x = EVENT_LEVELS.indexOf(event.getLevel().getLevel());
            if (x <= i) continue;
            i = x;
        }
        return i;
    }
}

