/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.Product;
import com.atlassian.stash.internal.home.DefaultEnvironmentVariableResolver;
import com.atlassian.stash.internal.home.EnvironmentVariableResolver;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.InvalidHomeDirectoryException;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class HomeDirectoryResolver {
    static final String HOME_DIR_ENV_VARIABLE = "STASH_HOME";
    static final String SHARED_HOME_DIR_ENV_VARIABLE = "STASH_SHARED_HOME";
    private final EnvironmentVariableResolver environmentVariableResolver;

    public HomeDirectoryResolver() {
        this(new DefaultEnvironmentVariableResolver());
    }

    public HomeDirectoryResolver(@Nonnull EnvironmentVariableResolver environmentVariableResolver) {
        this.environmentVariableResolver = environmentVariableResolver;
    }

    public HomeDirectoryDetails resolve() {
        File home = this.getHomeDirectory();
        File sharedHome = this.getSharedHomeDirectory(home);
        return new HomeDirectoryDetails(home, sharedHome);
    }

    public HomeDirectoryDetails resolveAndValidate() {
        HomeDirectoryDetails details = this.resolve();
        this.validate(details);
        return details;
    }

    private File getHomeDirectory() {
        String home = this.getPropertyValue("stash.home", HOME_DIR_ENV_VARIABLE, null);
        Preconditions.checkState((home != null ? 1 : 0) != 0, (String)"No home directory is defined using either the system property '%s' or the environment variable '%s'", (Object[])new Object[]{"stash.home", HOME_DIR_ENV_VARIABLE});
        this.checkTilde(home, "home");
        return HomeDirectoryResolver.resolve(home);
    }

    private File getSharedHomeDirectory(final File home) {
        String sharedHome = this.getPropertyValue("stash.shared.home", SHARED_HOME_DIR_ENV_VARIABLE, new Supplier<String>(){

            public String get() {
                return new File(home, "shared").getAbsolutePath();
            }
        });
        Preconditions.checkState((sharedHome != null ? 1 : 0) != 0, (Object)"Cannot derive shared home value from home value");
        this.checkTilde(sharedHome, "shared home");
        return HomeDirectoryResolver.resolve(sharedHome);
    }

    private String getPropertyValue(String propertyName, String environmentName, Supplier<String> missingValueSupplier) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = this.environmentVariableResolver.getValue(environmentName);
        if (propertyValue == null && missingValueSupplier != null) {
            propertyValue = (String)missingValueSupplier.get();
        }
        if (propertyValue != null) {
            System.setProperty(propertyName, propertyValue);
        }
        return propertyValue;
    }

    private void checkTilde(String text, String directoryName) {
        if (text != null && text.startsWith("~")) {
            throw new IllegalStateException("The " + directoryName + " directory [" + text + "] is invalid; " + "tilde expansion is not supported. Please use an absolute path referring to a specific home directory.");
        }
    }

    private void checkNotInCatalinaHome(File directory, String directoryName) {
        Path catalinaHomePath;
        Path directoryPath;
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null && (directoryPath = directory.toPath()).startsWith(catalinaHomePath = HomeDirectoryResolver.resolve(catalinaHome).toPath())) {
            throw new InvalidHomeDirectoryException("The %s directory [%s] must not be the same directory as or a subdirectory of the %s installation directory.", directoryName, directory.getAbsolutePath(), Product.NAME);
        }
    }

    private void validate(HomeDirectoryDetails details) {
        this.validateDirectory(details.getHome(), "home");
        this.validateDirectory(details.getSharedHome(), "shared home");
    }

    private void validateDirectory(File directory, String directoryName) {
        this.checkNotInCatalinaHome(directory, directoryName);
    }

    private static File resolve(String dirName) {
        File dir = new File(dirName);
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir.getAbsoluteFile();
        }
    }

    static {
        System.setProperty("hazelcast.logging.type", "slf4j");
    }
}

