/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.stash.internal.setting.MapSettings;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.setting.SettingsBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class MapSettingsBuilder
implements SettingsBuilder {
    private final ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();

    @Nonnull
    public SettingsBuilder add(@Nonnull String key, @Nonnull String value) {
        this.builder.put((Object)key, (Object)value);
        return this;
    }

    @Nonnull
    public SettingsBuilder add(@Nonnull String key, boolean value) {
        this.builder.put((Object)key, (Object)value);
        return this;
    }

    @Nonnull
    public SettingsBuilder add(@Nonnull String key, int value) {
        this.builder.put((Object)key, (Object)value);
        return this;
    }

    @Nonnull
    public SettingsBuilder add(@Nonnull String key, long value) {
        this.builder.put((Object)key, (Object)value);
        return this;
    }

    @Nonnull
    public SettingsBuilder add(@Nonnull String key, double value) {
        this.builder.put((Object)key, (Object)value);
        return this;
    }

    @Nonnull
    public SettingsBuilder addAll(@Nonnull Map<String, ?> values) {
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            String key = (String)Preconditions.checkNotNull((Object)entry.getKey(), (Object)"key");
            Object value = entry.getValue();
            if (value == null) continue;
            Preconditions.checkArgument((value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double ? 1 : 0) != 0, (String)"value of type %s is not supported", (Object[])new Object[]{value.getClass()});
            this.builder.put((Object)key, value);
        }
        return this;
    }

    @Nonnull
    public SettingsBuilder addAll(@Nonnull Settings settings) {
        this.builder.putAll(settings.asMap());
        return this;
    }

    @Nonnull
    public Settings build() {
        return new MapSettings((Map<String, Object>)this.builder.build());
    }
}

