/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.RepositoryActivity;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_repo_activity_id"))
@Table(name="sta_repo_activity", indexes={@Index(name="idx_sta_repo_activity_repo", columnList="repository_id")})
public abstract class InternalRepositoryActivity
extends InternalActivity
implements RepositoryActivity {
    public static final String TABLE = "sta_repo_activity";
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_repo_activity_repo"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalRepositoryActivity() {
    }

    protected InternalRepositoryActivity(AbstractRepositoryActivityBuilder<?, ?> builder) {
        super(builder);
        this.repository = ((AbstractRepositoryActivityBuilder)builder).repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    protected static abstract class AbstractRepositoryActivityBuilder<B extends AbstractRepositoryActivityBuilder<B, A>, A extends InternalRepositoryActivity>
    extends InternalActivity.AbstractActivityBuilder<B, A> {
        private final InternalRepository repository;

        protected AbstractRepositoryActivityBuilder(@Nonnull InternalRepository repository) {
            this.repository = (InternalRepository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        protected AbstractRepositoryActivityBuilder(@Nonnull InternalRepositoryActivity activity) {
            super(activity);
            this.repository = activity.getRepository();
        }
    }
}

