/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.participant.InternalAbstractParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRole;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_pr_participant", indexes={@Index(name="idx_sta_pr_participant_pr", columnList="pr_id"), @Index(name="idx_sta_pr_participant_user", columnList="user_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_pr_participant_pr_user", columnNames={"pr_id", "user_id"})})
@TableGenerator(allocationSize=5, pkColumnValue="sta_pr_participant", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequestParticipant
extends InternalAbstractParticipant<InternalPullRequestParticipant>
implements PullRequestParticipant {
    public static final String TABLE = "sta_pr_participant";
    @Column(name="pr_approved", nullable=false)
    private final boolean approved;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_participant_pr"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;
    @Column(name="pr_role", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestRole")})
    private final PullRequestRole role;

    protected InternalPullRequestParticipant() {
        this.pullRequest = null;
        this.role = null;
        this.approved = false;
    }

    private InternalPullRequestParticipant(Builder builder) {
        super(builder);
        this.approved = builder.approved;
        this.pullRequest = builder.pullRequest;
        this.role = builder.role;
    }

    @Nonnull
    public InternalPullRequest getEntity() {
        return this.getPullRequest();
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public PullRequestRole getRole() {
        return this.role;
    }

    @Override
    @Nonnull
    public InternalStashUser getUser() {
        return super.getUser();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
        super.initialize();
    }

    public boolean isApproved() {
        return this.approved;
    }

    public static class Builder
    extends InternalAbstractParticipant.AbstractParticipantBuilder<Builder, InternalPullRequestParticipant> {
        private final InternalPullRequest pullRequest;
        private boolean approved;
        private PullRequestRole role;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            this.pullRequest = (InternalPullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            this.role = PullRequestRole.PARTICIPANT;
        }

        public Builder(@Nonnull InternalPullRequestParticipant participant) {
            super(participant);
            this.approved = participant.isApproved();
            this.pullRequest = participant.getPullRequest();
            this.role = participant.getRole();
        }

        @Nonnull
        public Builder approved(boolean value) {
            this.approved = value;
            return this.self();
        }

        @Override
        @Nonnull
        public InternalPullRequestParticipant build() {
            return new InternalPullRequestParticipant(this);
        }

        @Nonnull
        public Builder role(@Nonnull PullRequestRole value) {
            this.role = (PullRequestRole)Preconditions.checkNotNull((Object)value, (Object)"role");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

