/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.stash.commit.CommitDiscussionParticipant;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.participant.InternalAbstractParticipant;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="sta_cmt_disc_participant", indexes={@Index(name="idx_sta_cmt_disc_part_disc", columnList="discussion_id"), @Index(name="idx_sta_cmt_disc_part_user", columnList="user_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_cmt_disc_part_disc_user", columnNames={"discussion_id", "user_id"})})
@TableGenerator(allocationSize=5, pkColumnValue="sta_cmt_disc_participant", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalCommitDiscussionParticipant
extends InternalAbstractParticipant<InternalCommitDiscussionParticipant>
implements CommitDiscussionParticipant {
    public static final String TABLE = "sta_cmt_disc_participant";
    @JoinColumn(name="discussion_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_cmt_disc_part_disc"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalCommitDiscussion discussion;

    protected InternalCommitDiscussionParticipant() {
        this.discussion = null;
    }

    private InternalCommitDiscussionParticipant(Builder builder) {
        super(builder);
        this.discussion = builder.discussion;
    }

    @Nonnull
    public InternalCommitDiscussion getDiscussion() {
        return this.discussion;
    }

    @Nonnull
    public InternalCommitDiscussion getEntity() {
        return this.getDiscussion();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getDiscussion());
        super.initialize();
    }

    public static class Builder
    extends InternalAbstractParticipant.AbstractParticipantBuilder<Builder, InternalCommitDiscussionParticipant> {
        private final InternalCommitDiscussion discussion;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            this.discussion = (InternalCommitDiscussion)Preconditions.checkNotNull((Object)discussion, (Object)"discussion");
        }

        public Builder(@Nonnull InternalCommitDiscussionParticipant participant) {
            super(participant);
            this.discussion = participant.getDiscussion();
        }

        @Override
        @Nonnull
        public InternalCommitDiscussionParticipant build() {
            return new InternalCommitDiscussionParticipant(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

