/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.comment.AbstractAddCommentRequest;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.DiffCommentAnchor;
import com.atlassian.stash.content.DiffFileType;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.atlassian.stash.validation.groups.Create;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@DiscriminatorColumn(name="anchor_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="sta_diff_comment_anchor", indexes={@Index(name="idx_sta_diff_comment_from_hash", columnList="from_hash"), @Index(name="idx_sta_diff_comment_to_hash", columnList="to_hash"), @Index(name="idx_sta_diff_comment_to_path", columnList="to_path"), @Index(name="idx_sta_diff_comment_comment", columnList="comment_id")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalDiffCommentAnchor
implements DiffCommentAnchor,
Initializable {
    public static final String ID_GEN = "diffCommentAnchorIdGenerator";
    public static final String TABLE = "sta_diff_comment_anchor";
    @JoinColumn(name="comment_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_diff_comment_comment"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="file_type")
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.content.DiffFileType")})
    private final DiffFileType fileType;
    @Column(name="from_hash", length=40)
    @OptionalString(minimumSize=40, size=40, groups={Create.class})
    private final String fromHash;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="diffCommentAnchorIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_diff_comment_anchor", name="diffCommentAnchorIdGenerator", table="id_sequence")
    private final Long id;
    @Column(name="line_number", nullable=false)
    private final int line;
    @Column(name="line_type")
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.content.DiffSegmentType")})
    private final DiffSegmentType lineType;
    @Column(name="to_path", nullable=false, length=1024, updatable=false)
    @RequiredString(size=1024, groups={Create.class})
    private final String path;
    @Column(name="from_path", length=1024, updatable=false)
    @OptionalString(size=1024, groups={Create.class})
    private final String srcPath;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40, groups={Create.class})
    private final String toHash;
    @Column(name="anchor_type", nullable=false, updatable=false)
    private final int type;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;

    protected InternalDiffCommentAnchor() {
        this.comment = null;
        this.fileType = null;
        this.toHash = null;
        this.srcPath = null;
        this.path = null;
        this.fromHash = null;
        this.id = null;
        this.line = 0;
        this.lineType = null;
        this.type = -1;
        this.version = 0;
    }

    protected InternalDiffCommentAnchor(AbstractBuilder<?, ?> builder) {
        this.comment = builder.comment;
        this.fileType = builder.fileType;
        this.fromHash = builder.fromHash;
        this.id = builder.id;
        this.line = builder.line;
        this.lineType = builder.lineType;
        this.path = builder.path;
        this.srcPath = builder.srcPath;
        this.toHash = builder.toHash;
        this.version = builder.version;
        DiscriminatorValue value = this.getClass().getAnnotation(DiscriminatorValue.class);
        if (value == null) {
            throw new IllegalStateException("DiffCommentAnchor class [" + this.getClass().getName() + "] does not have a DiscriminatorValue annotation");
        }
        this.type = Integer.parseInt(value.value());
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    public DiffFileType getFileType() {
        return this.fileType;
    }

    public String getFromHash() {
        return this.fromHash;
    }

    public Long getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getComment());
    }

    public boolean isFileComment() {
        return this.line == 0 || this.lineType == null;
    }

    public boolean isLineComment() {
        return this.line > 0 && this.lineType != null;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, A>, A extends InternalDiffCommentAnchor> {
        protected InternalComment comment;
        protected DiffFileType fileType;
        protected String fromHash;
        protected Long id;
        protected int line;
        protected DiffSegmentType lineType;
        protected String path;
        protected String srcPath;
        protected String toHash;
        protected int version;

        public AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull A anchor) {
            this.comment = ((InternalDiffCommentAnchor)Preconditions.checkNotNull(anchor, (Object)"anchor")).getComment();
            this.fileType = ((InternalDiffCommentAnchor)anchor).getFileType();
            this.fromHash = ((InternalDiffCommentAnchor)anchor).getFromHash();
            this.id = ((InternalDiffCommentAnchor)anchor).getId();
            this.line = ((InternalDiffCommentAnchor)anchor).getLine();
            this.lineType = ((InternalDiffCommentAnchor)anchor).getLineType();
            this.path = ((InternalDiffCommentAnchor)anchor).getPath();
            this.srcPath = ((InternalDiffCommentAnchor)anchor).getSrcPath();
            this.toHash = ((InternalDiffCommentAnchor)anchor).getToHash();
            this.version = ((InternalDiffCommentAnchor)anchor).getVersion();
        }

        @Nonnull
        public B apply(@Nonnull AbstractAddCommentRequest request) {
            this.path = request.getPath();
            this.srcPath = request.getSrcPath();
            if (request instanceof AddDiffCommentRequest) {
                AddDiffCommentRequest diff = (AddDiffCommentRequest)request;
                this.fileType = diff.getFileType();
                this.line = diff.getLine();
                this.lineType = diff.getLineType();
            }
            return this.self();
        }

        @Nonnull
        public abstract A build();

        @Nonnull
        public B comment(@Nonnull InternalComment value) {
            this.comment = (InternalComment)Preconditions.checkNotNull((Object)value, (Object)"comment");
            return this.self();
        }

        @Nonnull
        public B fromHash(@Nullable String value) {
            this.fromHash = value;
            return this.self();
        }

        @Nonnull
        public B id(@Nullable Long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public B line(int line, @Nonnull DiffSegmentType lineType, @Nonnull DiffFileType fileType) {
            this.line = line;
            this.lineType = (DiffSegmentType)Preconditions.checkNotNull((Object)lineType, (Object)"lineType");
            this.fileType = (DiffFileType)Preconditions.checkNotNull((Object)fileType, (Object)"fileType");
            return this.self();
        }

        @Nonnull
        public B path(@Nonnull String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A path is required.");
            this.path = value;
            return this.self();
        }

        @Nonnull
        public B srcPath(@Nullable String value) {
            this.srcPath = value;
            return this.self();
        }

        @Nonnull
        public B toHash(@Nonnull String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"toHash")).trim().isEmpty() ? 1 : 0) != 0, (Object)"The \"to\" hash is required.");
            this.toHash = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

