/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.change.custom.CustomChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class LiquibaseUtils {
    public static final String CUSTOM_CHANGE_PACKAGE = AbstractCustomChange.class.getPackage().getName();
    private static final Function<BeanDefinition, Class<?>> BEAN_DEFINITION_TO_CLASS = new Function<BeanDefinition, Class<?>>(){

        public Class<?> apply(BeanDefinition definition) {
            try {
                return Class.forName(definition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Bean class was missing from the class path", e);
            }
        }
    };

    private LiquibaseUtils() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static Set<Class<?>> findCustomChanges() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(CustomChange.class));
        return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)provider.findCandidateComponents(CUSTOM_CHANGE_PACKAGE), BEAN_DEFINITION_TO_CLASS));
    }

    public static Connection getConnection(Database database) {
        return ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
    }

    public static JdbcTemplate getJdbcTemplate(Database database) {
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource(LiquibaseUtils.getConnection(database), true);
        return new JdbcTemplate((DataSource)dataSource);
    }
}

