/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class ChangesetRepositoryMembershipDedupeChange
extends AbstractCustomChange
implements CustomTaskChange {
    private static final int MAX_BATCH_SIZE = 25;
    private static final Logger log = LoggerFactory.getLogger(ChangesetRepositoryMembershipDedupeChange.class);

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        Collection<MembershipRow> dupeMemberShip = this.findDuplicateEntries(template);
        log.debug("{} duplicate cs_repo_membership rows found", (Object)dupeMemberShip.size());
        if (!dupeMemberShip.isEmpty()) {
            this.deleteDupeEntries(template, dupeMemberShip);
            this.recreateEntries(template, dupeMemberShip);
            log.debug("Duplicate cs_repo_membership rows deleted");
        }
    }

    private void recreateEntries(JdbcTemplate template, Collection<MembershipRow> dupeMemberShip) throws CustomChangeException {
        try {
            Iterable entryBatches = Iterables.partition(dupeMemberShip, (int)25);
            for (final List entries : entryBatches) {
                template.batchUpdate("insert into cs_repo_membership (cs_id, repository_id) values (?, ?)", new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        MembershipRow entry = (MembershipRow)entries.get(i);
                        ps.setString(1, entry.changesetId);
                        ps.setInt(2, entry.repositoryId);
                    }

                    public int getBatchSize() {
                        return entries.size();
                    }
                });
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to create cs_repo_membership rows", (Throwable)e);
            throw new CustomChangeException("Failed to create cs_repo_membership rows", (Throwable)e);
        }
    }

    private void deleteDupeEntries(JdbcTemplate template, Collection<MembershipRow> dupeMemberShip) throws CustomChangeException {
        try {
            Iterable batches = Iterables.partition(dupeMemberShip, (int)25);
            for (final List indexStateKeysToRemove : batches) {
                template.batchUpdate("delete from cs_repo_membership where cs_id = ? and repository_id = ?", new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        MembershipRow entry = (MembershipRow)indexStateKeysToRemove.get(i);
                        ps.setString(1, entry.changesetId);
                        ps.setInt(2, entry.repositoryId);
                    }

                    public int getBatchSize() {
                        return indexStateKeysToRemove.size();
                    }
                });
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to delete some duplicate cs_repo_membership rows", (Throwable)e);
            throw new CustomChangeException("Failed to delete some duplicate cs_repo_membership rows", (Throwable)e);
        }
    }

    private Collection<MembershipRow> findDuplicateEntries(JdbcTemplate template) throws CustomChangeException {
        final ArrayList memberShips = Lists.newArrayList();
        try {
            template.query("select cs_id, repository_id from cs_repo_membership group by cs_id, repository_id having count(1) > 1", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    memberShips.add(new MembershipRow(rs.getString("cs_id"), rs.getInt("repository_id")));
                }
            });
            return memberShips;
        }
        catch (DataAccessException e) {
            log.error("Failed to query cs_repo_membership", (Throwable)e);
            throw new CustomChangeException("Failed to query cs_repo_membership", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return "Duplicate entries in cs_repo_membership removed.";
    }

    private static class MembershipRow {
        final String changesetId;
        final int repositoryId;

        private MembershipRow(String changesetId, int repositoryId) {
            this.changesetId = changesetId;
            this.repositoryId = repositoryId;
        }
    }
}

