/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.hibernate.extras.hql.JoinTemporaryTableBulkIdStrategy;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.validation.ValidatorFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;
import org.springframework.util.CollectionUtils;

public class ExtendedLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private static final DuplicationStrategy USE_DERIVED = new DuplicationStrategy(){

        public boolean areMatch(Object added, Object existing) {
            Class<?> existingClass = existing.getClass();
            Class<?> addedClass = added.getClass();
            return !addedClass.equals(existingClass) && existingClass.isInstance(added);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.REPLACE_ORIGINAL;
        }
    };
    private final DataSourceConfiguration dataSourceConfiguration;
    private Map<EventType, Object> eventListeners;
    private ValidatorFactory validatorFactory;

    public ExtendedLocalSessionFactoryBean(DataSource dataSource, DataSourceConfiguration dataSourceConfiguration) {
        this.setDataSource(dataSource);
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    public Class<SessionFactoryImplementor> getObjectType() {
        return SessionFactoryImplementor.class;
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder configuration) throws HibernateException {
        this.customizeConfiguration(configuration);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)super.buildSessionFactory(configuration);
        this.registerEventListeners(sessionFactory);
        return sessionFactory;
    }

    @VisibleForTesting
    void customizeConfiguration(LocalSessionFactoryBuilder configuration) {
        this.applyMultiTableBulkIdStrategy(configuration);
        this.applyValidatorFactory(configuration);
    }

    private void applyMultiTableBulkIdStrategy(LocalSessionFactoryBuilder sfb) {
        if (DbType.forDriver((String)this.dataSourceConfiguration.getDriverClassName()).getOrNull() == DbType.MYSQL) {
            Properties bulkIdStrategyProperties = new Properties();
            bulkIdStrategyProperties.setProperty("hibernate.hql.bulk_id_strategy", JoinTemporaryTableBulkIdStrategy.class.getName());
            sfb.addProperties(bulkIdStrategyProperties);
        }
    }

    private void applyValidatorFactory(LocalSessionFactoryBuilder sfb) {
        if (this.validatorFactory != null) {
            Properties validatorProperties = new Properties();
            validatorProperties.put("javax.persistence.validation.factory", this.validatorFactory);
            sfb.addProperties(validatorProperties);
        }
    }

    private void registerEventListeners(SessionFactoryImplementor sessionFactory) {
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
            EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
            for (Map.Entry<EventType, Object> entry : this.eventListeners.entrySet()) {
                EventListenerGroup group = listenerRegistry.getEventListenerGroup(entry.getKey());
                group.addDuplicationStrategy(USE_DERIVED);
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    group.appendListeners(((Collection)value).toArray());
                    continue;
                }
                group.appendListener(value);
            }
        }
    }

    public void setEventListeners(Map<EventType, Object> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }
}

