/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.RemoveUserOperation;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.ProjectModifiedEvent;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.AbstractVoidInternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.project.Project;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class HibernateUserDao
extends UserDAOHibernate
implements UserDao,
InternalUserDao {
    private final EventPublisher eventPublisher;
    private final ProjectDao projectDao;
    private final TransactionTemplate readOnlyTxTemplate;
    private final StashUserDao stashUserDao;
    private ApplicationFactory applicationFactory;
    private int batchSize;

    @Autowired
    public HibernateUserDao(EventPublisher eventPublisher, ProjectDao projectDao, StashUserDao stashUserDao, PlatformTransactionManager transactionManager) {
        this.eventPublisher = eventPublisher;
        this.projectDao = projectDao;
        this.stashUserDao = stashUserDao;
        this.readOnlyTxTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTxTemplate.setReadOnly(true);
    }

    public InternalUser add(com.atlassian.crowd.model.user.User user, PasswordCredential passwordCredential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        this.stashUserDao.createFor((User)user);
        return super.add(user, passwordCredential);
    }

    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> userTemplateWithCredentialAndAttributes) {
        BatchResult result = super.addAll(userTemplateWithCredentialAndAttributes);
        int count = 0;
        for (com.atlassian.crowd.model.user.User createdUser : result.getSuccessfulEntities()) {
            this.stashUserDao.createFor((User)createdUser);
            if (++count < this.batchSize) continue;
            count = 0;
            this.session().flush();
            this.session().clear();
        }
        return result;
    }

    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        return HibernateUserDao.initialize(super.findByName(directoryId, username));
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        InternalUserWithAttributes result = super.findByNameWithAttributes(directoryId, username);
        HibernateUserDao.initialize(result.getInternalUser());
        return result;
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return this.detach(super.findByNames(directoryID, usernames));
    }

    public Set<InternalUserAttribute> findUserAttributes(long userID) {
        Set result = super.findUserAttributes(userID);
        for (InternalUserAttribute attribute : result) {
            HibernateUserDao.initialize(attribute.getUser());
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(attribute.getDirectory()));
        }
        return result;
    }

    public Object load(long ID) throws ObjectNotFoundException {
        return HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(super.load(ID)));
    }

    public Object loadReference(long id) {
        return HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(super.loadReference(id)));
    }

    public BatchResult<String> removeAllUsers(final long directoryId, final Set<String> userNames) {
        Collection users = (Collection)this.readOnlyTxTemplate.execute((TransactionCallback)new TransactionCallback<Collection<InternalUser>>(){

            public Collection<InternalUser> doInTransaction(TransactionStatus status) {
                return HibernateUserDao.this.findByNames(directoryId, userNames);
            }
        });
        BatchResult batchResult = this.batchProcessor.execute((HibernateOperation)new RemoveUserOperation(), users);
        BatchResult overallResult = new BatchResult(userNames.size());
        overallResult.addFailures(Collections2.transform((Collection)batchResult.getFailedEntities(), (Function)InternalEntityUtils.GET_NAME));
        overallResult.addSuccesses(Collections2.transform((Collection)batchResult.getSuccessfulEntities(), (Function)InternalEntityUtils.GET_NAME));
        return overallResult;
    }

    public InternalUser rename(com.atlassian.crowd.model.user.User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        String oldUsername = user.getName();
        boolean shouldRenameStashUser = this.archiveIfNeeded(user.getDirectoryId(), oldUsername, newUsername);
        InternalUser renamedUser = super.rename(user, newUsername);
        if (shouldRenameStashUser) {
            InternalNormalUser renamedStashUser = this.stashUserDao.rename(oldUsername, newUsername);
            if (renamedStashUser == null) {
                this.logger.info("User {} not found during rename to {}. Creating a new user instead.", (Object)user.getName(), (Object)newUsername);
                this.stashUserDao.createFor((User)renamedUser);
            } else {
                renamedStashUser.accept((InternalStashUserVisitor)new AbstractVoidInternalStashUserVisitor(){

                    protected void doVisit(@Nonnull InternalNormalUser renamedStashUser) {
                        HibernateUserDao.this.renamePersonalProject(renamedStashUser);
                    }
                });
            }
        }
        return renamedUser;
    }

    public <T> List<T> search(long directoryID, EntityQuery<T> query) {
        List result = super.search(directoryID, query);
        for (Object item : result) {
            if (item instanceof InternalUser) {
                HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(item));
            }
            if (!(item instanceof InternalUserCredentialRecord)) continue;
            HibernateUserDao.initialize(((InternalUserCredentialRecord)InternalUserCredentialRecord.class.cast(item)).getUser());
        }
        return result;
    }

    @Autowired
    public void setApplicationFactory(ApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
    }

    @Value(value="${hibernate.jdbc.batch_size}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    static InternalUser initialize(InternalUser user) {
        if (user != null) {
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(user.getDirectory()));
            Hibernate.initialize((Object)user.getCredentialRecords());
            for (InternalUserCredentialRecord credentialRecord : user.getCredentialRecords()) {
                Hibernate.initialize((Object)credentialRecord.getUser());
            }
        }
        return user;
    }

    @VisibleForTesting
    boolean archiveIfNeeded(long directoryId, String oldUsername, String newUsername) throws UserAlreadyExistsException {
        InternalNormalUser existingUser;
        if (!IdentifierUtils.equalsInLowerCase((String)oldUsername, (String)newUsername) && (existingUser = this.stashUserDao.findByName(newUsername)) != null) {
            User backingCrowdUser = (User)existingUser.accept(InternalStashUser.TO_CROWD_USER);
            if (backingCrowdUser != null) {
                this.logger.debug("Existing stash user is backed by a crowd user with name [{}] in directory [{}]", (Object)backingCrowdUser.getName(), (Object)backingCrowdUser.getDirectoryId());
                if (backingCrowdUser.getDirectoryId() == directoryId) {
                    throw new UserAlreadyExistsException(backingCrowdUser.getDirectoryId(), existingUser.getName());
                }
                if (this.isDirectoryLowerPrecedence(directoryId, backingCrowdUser.getDirectoryId())) {
                    this.logger.debug("Crowd user with name [{}] in directory [{}] is going to be shadowed. The associated stash users will remain untouched", (Object)backingCrowdUser.getName(), (Object)backingCrowdUser.getDirectoryId());
                    return false;
                }
            }
            existingUser = this.stashUserDao.archive(existingUser);
            this.renamePersonalProject(existingUser);
        }
        return true;
    }

    Collection<InternalUser> detach(Collection<InternalUser> users) {
        if (users != null) {
            Session session = this.session();
            for (InternalUser user : users) {
                HibernateUserDao.initialize(user);
                session.evict((Object)user);
            }
        }
        return users;
    }

    @VisibleForTesting
    void renamePersonalProject(InternalNormalUser user) {
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId().intValue());
        if (project != null) {
            InternalPersonalProject current = project.copy().build();
            InternalPersonalProject updated = current.copy().owner(user).build();
            if (!current.getKey().equals(updated.getKey())) {
                updated = (InternalProject)this.projectDao.update((Object)updated);
                this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)updated));
            }
        }
    }

    private boolean isDirectoryLowerPrecedence(long firstDirectoryId, long secondDirectoryId) {
        Application application = this.applicationFactory.getApplication();
        for (DirectoryMapping mapping : application.getDirectoryMappings()) {
            if (firstDirectoryId == mapping.getDirectory().getId()) {
                return false;
            }
            if (secondDirectoryId != mapping.getDirectory().getId()) continue;
            return true;
        }
        throw new IllegalStateException(String.format("Neither directory %d or %d exist", firstDirectoryId, secondDirectoryId));
    }
}

