/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSetMetaData;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ChangeLogOutline
implements Iterable<LiquibaseChangeSetMetaData> {
    private final List<LiquibaseChangeSetMetaData> changeSetMetaDatas;
    private final int nonEmptyChangeSetCount;

    ChangeLogOutline(Iterable<Long> changeCounts) {
        int size = Iterables.size(changeCounts);
        if (size > 100) {
            throw new IllegalArgumentException("The current changelog backup and restore process supports a maximum of 100 changesets.");
        }
        this.changeSetMetaDatas = new ArrayList<LiquibaseChangeSetMetaData>(size);
        long totalChangeCount = 0L;
        int nonEmptyChangeSetCount = 0;
        for (Long changeCount : changeCounts) {
            totalChangeCount += changeCount.longValue();
            if (changeCount <= 0L) continue;
            ++nonEmptyChangeSetCount;
        }
        long cumulativeCount = 0L;
        int cumulativeWeight = 0;
        int nonEmptyChangeSetsRemaining = nonEmptyChangeSetCount;
        for (Long changeCount : changeCounts) {
            cumulativeCount += changeCount.longValue();
            int desiredCumulativeWeight = 0;
            if (totalChangeCount > 0L) {
                desiredCumulativeWeight = (int)(cumulativeCount * 100L / totalChangeCount);
            }
            int weight = 0;
            if (changeCount > 0L) {
                weight = desiredCumulativeWeight - cumulativeWeight;
                weight = Math.max(1, weight);
                weight = Math.min(weight, 100 - cumulativeWeight - --nonEmptyChangeSetsRemaining);
            }
            this.changeSetMetaDatas.add(new LiquibaseChangeSetMetaData(changeCount, weight));
            cumulativeWeight += weight;
        }
        this.nonEmptyChangeSetCount = nonEmptyChangeSetCount;
    }

    @Override
    public Iterator<LiquibaseChangeSetMetaData> iterator() {
        return this.changeSetMetaDatas.iterator();
    }

    public int nonEmptyChangeSetCount() {
        return this.nonEmptyChangeSetCount;
    }
}

