/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestState;
import java.util.Collection;

public class PullRequestSearchCriteria {
    public static final int NO_ID = -1;
    private Collection<String> fromRefIds;
    private int fromRepositoryId = -1;
    private PullRequestOrder order;
    private PullRequestRole participantRole;
    private PullRequestState state;
    private Boolean approved;
    private Collection<String> toRefIds;
    private int toRepositoryId = -1;
    private int userId = -1;

    public PullRequestSearchCriteria() {
    }

    public PullRequestSearchCriteria(PullRequestSearchRequest request) {
        this();
        this.setState(request.getState());
        this.setFromRefIds(request.getFromRefIds());
        if (request.getFromRepositoryId() != null) {
            this.setFromRepositoryId(request.getFromRepositoryId());
        }
        this.setToRefIds(request.getToRefIds());
        if (request.getToRepositoryId() != null) {
            this.setToRepositoryId(request.getToRepositoryId());
        }
        this.setOrder(request.getOrder());
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    public PullRequestOrder getOrder() {
        return this.order;
    }

    public PullRequestRole getParticipantRole() {
        return this.participantRole;
    }

    public PullRequestState getState() {
        return this.state;
    }

    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public boolean hasApproved() {
        return this.approved != null;
    }

    public boolean hasFromRefIds() {
        return this.fromRefIds != null && !this.fromRefIds.isEmpty();
    }

    public boolean hasFromRepositoryId() {
        return this.fromRepositoryId != -1;
    }

    public boolean hasOrder() {
        return this.order != null;
    }

    public boolean hasParticipantRole() {
        return this.hasUserId() && this.participantRole != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasToRefIds() {
        return this.toRefIds != null && !this.toRefIds.isEmpty();
    }

    public boolean hasToRepositoryId() {
        return this.toRepositoryId != -1;
    }

    public boolean hasUserId() {
        return this.userId != -1;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public void setFromRefIds(Collection<String> fromRefIds) {
        this.fromRefIds = fromRefIds;
    }

    public void setFromRepositoryId(int fromRepositoryId) {
        this.fromRepositoryId = fromRepositoryId;
    }

    public void setOrder(PullRequestOrder order) {
        this.order = order;
    }

    public void setParticipantRole(PullRequestRole participantRole) {
        this.participantRole = participantRole;
    }

    public void setState(PullRequestState state) {
        this.state = state;
    }

    public void setToRefIds(Collection<String> toRefIds) {
        this.toRefIds = toRefIds;
    }

    public void setToRepositoryId(int toRepositoryId) {
        this.toRepositoryId = toRepositoryId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }
}

