/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestTaskSearchRequest
extends AbstractPullRequestRequest {
    private final Set<Long> anchorIds;
    private final PullRequest pullRequest;

    private PullRequestTaskSearchRequest(Builder builder) {
        super(builder.repositoryId, builder.pullRequestId);
        this.anchorIds = builder.anchorIds.build();
        this.pullRequest = builder.pullRequest;
    }

    @Nonnull
    public Set<Long> getAnchorIds() {
        return this.anchorIds;
    }

    @Nullable
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public boolean hasPullRequest() {
        return this.pullRequest != null;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private ImmutableSet.Builder<Long> anchorIds = ImmutableSet.builder();
        private PullRequest pullRequest;

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pull request")).getToRef().getRepository().getId(), pullRequest.getId());
            this.pullRequest = pullRequest;
        }

        @Nonnull
        public Builder anchor(long anchor) {
            this.anchorIds.add((Object)anchor);
            return this;
        }

        @Nonnull
        public Builder anchors(@Nullable Iterable<Long> value) {
            Builder.addIf(Predicates.notNull(), this.anchorIds, value);
            return this;
        }

        @Nonnull
        public PullRequestTaskSearchRequest build() {
            return new PullRequestTaskSearchRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

