/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.atlassian.stash.i18n.I18nKey;
import com.atlassian.stash.user.Permission;
import javax.annotation.Nonnull;

public class PermissionI18n {
    private static final String I18N_KEY_BASE = "stash.service.permission.%s.%s";
    private static final String I18N_DESCRIPTION = "description";
    private static final String I18N_NAME = "name";
    private static final String I18N_SHORT = "short";
    private final I18nKey description;
    private final I18nKey name;
    private final I18nKey shortName;

    PermissionI18n(Permission permission, Object[] arguments) {
        String permissionForI18n = permission.name().toLowerCase().replace("_", ".");
        this.description = new I18nKey(PermissionI18n.i18nKeyFor(permissionForI18n, I18N_DESCRIPTION), arguments);
        this.name = new I18nKey(PermissionI18n.i18nKeyFor(permissionForI18n, I18N_NAME), arguments);
        this.shortName = new I18nKey(PermissionI18n.i18nKeyFor(permissionForI18n, I18N_SHORT), arguments);
    }

    @Nonnull
    public I18nKey description() {
        return this.description;
    }

    @Nonnull
    public I18nKey name() {
        return this.name;
    }

    @Nonnull
    public I18nKey shortName() {
        return this.shortName;
    }

    private static String i18nKeyFor(String permissionKey, String suffix) {
        return String.format(I18N_KEY_BASE, permissionKey, suffix);
    }
}

