/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.content.FileContext;
import com.atlassian.stash.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class FileCommandParameters
extends AbstractCommitCommandParameters {
    private final boolean annotated;
    private final int maxLineLength;

    private FileCommandParameters(Builder builder) {
        super(builder);
        this.maxLineLength = builder.maxLineLength;
        this.annotated = builder.annotated;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    @Nonnull
    public FileContext toContext() {
        return new FileContext.Builder(this.getChangesetId()).maxLineLength(this.getMaxLineLength()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private boolean annotated;
        private int maxLineLength;

        public Builder annotate(boolean value) {
            this.annotated = value;
            return this;
        }

        public FileCommandParameters build() {
            if (StringUtils.isBlank((String)this.commitId)) {
                throw new IllegalStateException("A commit ID must provided when retrieving file contents");
            }
            if (StringUtils.isBlank((String)this.path)) {
                throw new IllegalStateException("A path must be provided when retrieving file contents");
            }
            return new FileCommandParameters(this);
        }

        public Builder maxLineLength(int value) {
            this.maxLineLength = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

