/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangesetsCommandParameters
extends AbstractCommandParameters {
    private final Set<String> commitIds;
    private final int maxChangesPerCommit;
    private final boolean ignoreMissing;

    private ChangesetsCommandParameters(Builder builder) {
        this.commitIds = builder.commitIds.build();
        this.ignoreMissing = builder.ignoreMissing;
        this.maxChangesPerCommit = builder.maxChangesPerCommit;
        if (this.commitIds.isEmpty()) {
            throw new IllegalStateException("At least one commit ID must be provided to retrieve changesets");
        }
        if (this.maxChangesPerCommit < 1) {
            throw new IllegalStateException("The maximum number of changes to include per commit must be greater than 0");
        }
    }

    @Nonnull
    public Set<String> getCommitIds() {
        return this.commitIds;
    }

    public int getMaxChangesPerCommit() {
        return this.maxChangesPerCommit;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> commitIds = ImmutableSet.builder();
        private boolean ignoreMissing;
        private int maxChangesPerCommit;

        @Nonnull
        public ChangesetsCommandParameters build() {
            return new ChangesetsCommandParameters(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, value);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable String value, String ... values) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, value, values);
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nullable Iterable<String> values) {
            ChangesetsCommandParameters.addIf(NOT_BLANK, this.commitIds, values);
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public Builder maxChangesPerCommit(int value) {
            this.maxChangesPerCommit = value;
            return this;
        }
    }
}

