/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestActivityType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestActivitySearchRequest
extends AbstractPullRequestRequest {
    private final Set<CommentAction> commentActions;
    private final Set<Long> commentIds;
    private final Set<PullRequestActivityType> types;
    private final boolean withPullRequestAttributes;
    private final boolean withProperties;

    private PullRequestActivitySearchRequest(Builder builder) {
        super(builder.repositoryId, builder.pullRequestId);
        this.commentActions = Collections.unmodifiableSet(builder.commentActions);
        this.commentIds = Collections.unmodifiableSet(builder.commentIds);
        this.types = Collections.unmodifiableSet(builder.types);
        this.withPullRequestAttributes = builder.withPullRequestAttributes;
        this.withProperties = builder.withProperties;
    }

    @Nonnull
    public Set<CommentAction> getCommentActions() {
        return this.commentActions;
    }

    @Nonnull
    public Set<Long> getCommentIds() {
        return this.commentIds;
    }

    @Nonnull
    public Set<PullRequestActivityType> getTypes() {
        return this.types;
    }

    @Deprecated
    public boolean isWithPullRequestAttributes() {
        return this.withPullRequestAttributes;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final Set<CommentAction> commentActions = EnumSet.noneOf(CommentAction.class);
        private final Set<Long> commentIds = new HashSet<Long>();
        private final Set<PullRequestActivityType> types = EnumSet.noneOf(PullRequestActivityType.class);
        private boolean withPullRequestAttributes;
        private boolean withProperties;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestActivitySearchRequest build() {
            Preconditions.checkArgument((this.commentActions.isEmpty() || this.types.contains((Object)PullRequestActivityType.COMMENT) ? 1 : 0) != 0, (Object)"the search request specifies comment actions yet does not search for comment activities");
            Preconditions.checkArgument((this.commentIds.isEmpty() || this.types.contains((Object)PullRequestActivityType.COMMENT) ? 1 : 0) != 0, (Object)"the search request specifies comment ids yet does not search for comment activities");
            return new PullRequestActivitySearchRequest(this);
        }

        @Nonnull
        public Builder commentActions(@Nullable CommentAction commentAction, CommentAction ... commentActions) {
            Builder.addIf(Predicates.notNull(), this.commentActions, commentAction, commentActions);
            return this.self();
        }

        @Nonnull
        public Builder commentActions(@Nullable Iterable<CommentAction> commentActions) {
            Builder.addIf(Predicates.notNull(), this.commentActions, commentActions);
            return this.self();
        }

        @Nonnull
        public Builder commentIds(@Nullable Long commentId, Long ... commentIds) {
            Builder.addIf(Predicates.notNull(), this.commentIds, commentId, commentIds);
            return this.self();
        }

        @Nonnull
        public Builder commentIds(@Nullable Iterable<Long> commentIds) {
            Builder.addIf(Predicates.notNull(), this.commentIds, commentIds);
            return this.self();
        }

        @Nonnull
        public Builder types(@Nullable PullRequestActivityType type, PullRequestActivityType ... types) {
            Builder.addIf(Predicates.notNull(), this.types, type, types);
            return this.self();
        }

        @Nonnull
        public Builder types(@Nullable Iterable<PullRequestActivityType> types) {
            Builder.addIf(Predicates.notNull(), this.types, types);
            return this.self();
        }

        @Deprecated
        @Nonnull
        public Builder withPullRequestAttributes(boolean withPullRequestAttributes) {
            this.withPullRequestAttributes = withPullRequestAttributes;
            return this.self();
        }

        @Nonnull
        public Builder withProperties(boolean withProperties) {
            this.withProperties = withProperties;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

