/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public abstract class AbstractRepositoryRequest {
    private final boolean forkable;
    private final String name;
    private final boolean publiclyAccessible;

    protected AbstractRepositoryRequest(String name, boolean forkable, boolean publiclyAccessible) {
        this.name = name;
        this.forkable = forkable;
        this.publiclyAccessible = publiclyAccessible;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends BuilderSupport {
        protected boolean forkable;
        protected String name;
        protected boolean publiclyAccessible;

        protected AbstractBuilder() {
            this.forkable = true;
        }

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.forkable = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).isForkable();
            this.name = repository.getName();
            this.publiclyAccessible = repository.isPublic();
        }

        protected AbstractBuilder(@Nonnull AbstractRepositoryRequest request) {
            this.forkable = ((AbstractRepositoryRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).isForkable();
            this.name = request.getName();
            this.publiclyAccessible = request.isPublic();
        }

        @Nonnull
        public B forkable(boolean value) {
            this.forkable = value;
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = AbstractBuilder.checkNotBlank(value, "name");
            return this.self();
        }

        @Nonnull
        public B publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        protected abstract B self();
    }
}

