/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.content.DiffWhitespace;
import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class PullRequestDiffRequest
extends AbstractPullRequestRequest {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private final int contextLines;
    private final String path;
    private final String srcPath;
    private final DiffWhitespace whitespace;
    private final boolean withComments;

    private PullRequestDiffRequest(Builder builder) {
        super(builder.repositoryId, builder.pullRequestId);
        this.contextLines = builder.contextLines;
        this.path = builder.path;
        this.srcPath = builder.srcPath;
        this.whitespace = builder.whitespace;
        this.withComments = builder.withComments;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public boolean hasContextLines() {
        return this.contextLines > -1;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final String path;
        private int contextLines;
        private String srcPath;
        private DiffWhitespace whitespace;
        private boolean withComments;

        public Builder(@Nonnull PullRequestDiffRequest request) {
            super(((PullRequestDiffRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getRepositoryId(), request.getPullRequestId());
            this.contextLines = request.getContextLines();
            this.path = request.getPath();
            this.srcPath = StringUtils.trimToNull((String)request.getSrcPath());
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)request.getWhitespace()), (Object)"request.whitespace"));
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull PullRequest pullRequest, @Nullable String path) {
            this(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository().getId(), pullRequest.getId(), path);
        }

        public Builder(int repositoryId, long pullRequestId, @Nullable String path) {
            super(repositoryId, pullRequestId);
            this.path = path;
            this.contextLines = -1;
            this.whitespace = DiffWhitespace.SHOW;
            this.withComments = true;
        }

        @Nonnull
        public PullRequestDiffRequest build() {
            return new PullRequestDiffRequest(this);
        }

        @Nonnull
        public Builder contextLines(int value) {
            this.contextLines = Math.max(-1, value);
            return this.self();
        }

        @Nonnull
        public Builder srcPath(@Nullable String value) {
            this.srcPath = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"whitespace"));
            return this.self();
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

